/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event.metrics.annotations;

import com.google.common.annotations.VisibleForTesting;
import com.palantir.logsafe.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.Nullable;

public final class AnnotationHelper {
    private AnnotationHelper() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static <T extends Annotation> T getSuperTypeAnnotation(Class<?> clazz, Class<T> annotation) {
        if (clazz.isAnnotationPresent(annotation)) {
            return clazz.getAnnotation(annotation);
        }
        for (Class<?> ifaces : AnnotationHelper.getParentClasses(clazz)) {
            T superAnnotation = AnnotationHelper.getSuperTypeAnnotation(ifaces, annotation);
            if (superAnnotation == null) continue;
            return superAnnotation;
        }
        return null;
    }

    @Nullable
    public static <T extends Annotation> T getMethodAnnotation(Class<T> annotation, Class<?> clazz, MethodSignature methodSignature) {
        Method method;
        try {
            method = clazz.getMethod(methodSignature.getMethodName(), methodSignature.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (method.isAnnotationPresent(annotation)) {
            return method.getAnnotation(annotation);
        }
        for (Class<?> iface : AnnotationHelper.getParentClasses(clazz)) {
            T foundAnnotation = AnnotationHelper.getMethodAnnotation(annotation, iface, methodSignature);
            if (foundAnnotation == null) continue;
            return foundAnnotation;
        }
        return null;
    }

    @VisibleForTesting
    private static Set<Class<?>> getParentClasses(Class<?> clazz) {
        Set<Class<?>> parentClasses = Collections.newSetFromMap(new IdentityHashMap());
        parentClasses.addAll(Arrays.asList(clazz.getInterfaces()));
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            parentClasses.addAll(Arrays.asList(superclass.getInterfaces()));
            parentClasses.add(superclass);
        }
        return parentClasses;
    }

    public static final class MethodSignature {
        private final String methodName;
        private final Class<?>[] parameterTypes;
        private static final Class<?>[] NO_ARGS = new Class[0];

        private MethodSignature(String methodName, Class<?> ... parameterTypes) {
            this.methodName = (String)Preconditions.checkNotNull((Object)methodName);
            this.parameterTypes = parameterTypes == null || parameterTypes.length == 0 ? NO_ARGS : (Class[])parameterTypes.clone();
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public String toString() {
            return "MethodSignature{methodName='" + this.methodName + "', parameterTypes=" + Arrays.toString(this.parameterTypes) + "}";
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MethodSignature that = (MethodSignature)other;
            if (this.getMethodName() != null ? !this.getMethodName().equals(that.getMethodName()) : that.getMethodName() != null) {
                return false;
            }
            return Arrays.equals(this.getParameterTypes(), that.getParameterTypes());
        }

        public int hashCode() {
            int result = this.getMethodName() != null ? this.getMethodName().hashCode() : 0;
            result = 31 * result + Arrays.hashCode(this.getParameterTypes());
            return result;
        }

        public static MethodSignature of(Method method) {
            return MethodSignature.of(method.getName(), method.getParameterTypes());
        }

        public static MethodSignature of(String methodName, Class<?> ... parameterTypes) {
            return new MethodSignature(methodName, parameterTypes);
        }
    }
}

