/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.Optional;

final class ExecutorMetrics {
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = Optional.ofNullable(ExecutorMetrics.class.getPackage().getImplementationVersion()).orElse("unknown");
    private final TaggedMetricRegistry registry;

    private ExecutorMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    public static ExecutorMetrics of(TaggedMetricRegistry registry) {
        return new ExecutorMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    Meter submitted(String executor) {
        return this.registry.meter(MetricName.builder().safeName("executor.submitted").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build());
    }

    @CheckReturnValue
    Counter running(String executor) {
        return this.registry.counter(MetricName.builder().safeName("executor.running").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build());
    }

    @CheckReturnValue
    Timer duration(String executor) {
        return this.registry.timer(MetricName.builder().safeName("executor.duration").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build());
    }

    @CheckReturnValue
    Timer queuedDuration(String executor) {
        return this.registry.timer(MetricName.builder().safeName("executor.queued-duration").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build());
    }

    @CheckReturnValue
    Counter scheduledOverrun(String executor) {
        return this.registry.counter(MetricName.builder().safeName("executor.scheduled.overrun").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build());
    }

    @CheckReturnValue
    Meter threadsCreated(String executor) {
        return this.registry.meter(MetricName.builder().safeName("executor.threads.created").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build());
    }

    @CheckReturnValue
    Counter threadsRunning(String executor) {
        return this.registry.counter(MetricName.builder().safeName("executor.threads.running").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build());
    }

    public String toString() {
        return "ExecutorMetrics{registry=" + this.registry + "}";
    }
}

