/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.palantir.tritium.metrics.HandshakeInstrumentation;
import com.palantir.tritium.metrics.TlsMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

final class InstrumentedSslSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;
    private final HandshakeCompletedListener listener;
    private final String name;

    InstrumentedSslSocketFactory(SSLSocketFactory delegate, TlsMetrics metrics, String name) {
        this.delegate = delegate;
        this.name = name;
        this.listener = InstrumentedSslSocketFactory.newHandshakeListener(metrics, name);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.wrap(this.delegate.createSocket(socket, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.wrap(this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress inetAddress, int clientPort) throws IOException {
        return this.wrap(this.delegate.createSocket(host, port, inetAddress, clientPort));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int port) throws IOException {
        return this.wrap(this.delegate.createSocket(inetAddress, port));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int port, InetAddress clientAddress, int clientPort) throws IOException {
        return this.wrap(this.delegate.createSocket(inetAddress, port, clientAddress, clientPort));
    }

    @Override
    public Socket createSocket(Socket socket, InputStream consumed, boolean autoClose) throws IOException {
        return this.wrap(this.delegate.createSocket(socket, consumed, autoClose));
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.wrap(this.delegate.createSocket());
    }

    public String toString() {
        return "InstrumentedSSLSocketFactory{delegate=" + this.delegate + ", name=" + this.name + "}";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InstrumentedSslSocketFactory that = (InstrumentedSslSocketFactory)other;
        return this.delegate.equals(that.delegate) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.delegate, this.name);
    }

    private Socket wrap(Socket socket) {
        if (socket instanceof SSLSocket && HandshakeInstrumentation.isSocketInstrumentationEnabled()) {
            ((SSLSocket)socket).addHandshakeCompletedListener(this.listener);
        }
        return socket;
    }

    static HandshakeCompletedListener newHandshakeListener(TlsMetrics metrics, String name) {
        return event -> HandshakeInstrumentation.record(metrics, name, event.getCipherSuite(), event.getSession().getProtocol());
    }
}

