/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Gauge;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.Optional;

final class JvmGcMetrics {
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = Optional.ofNullable(JvmGcMetrics.class.getPackage().getImplementationVersion()).orElse("unknown");
    private final TaggedMetricRegistry registry;

    private JvmGcMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    public static JvmGcMetrics of(TaggedMetricRegistry registry) {
        return new JvmGcMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    CountBuilderCollectorStage count() {
        return new CountBuilder();
    }

    @CheckReturnValue
    TimeBuilderCollectorStage time() {
        return new TimeBuilder();
    }

    void finalizerQueueSize(Gauge<?> gauge) {
        this.registry.registerWithReplacement(JvmGcMetrics.finalizerQueueSizeMetricName(), gauge);
    }

    static MetricName finalizerQueueSizeMetricName() {
        return MetricName.builder().safeName("jvm.gc.finalizer.queue.size").putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build();
    }

    public String toString() {
        return "JvmGcMetrics{registry=" + this.registry + "}";
    }

    private final class TimeBuilder
    implements TimeBuilderCollectorStage,
    TimeBuildStage {
        private String collector;

        private TimeBuilder() {
        }

        @Override
        public void build(Gauge<?> gauge) {
            JvmGcMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.gc.time").putSafeTags("collector", this.collector).putSafeTags("libraryName", JvmGcMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build();
        }

        @Override
        public TimeBuilder collector(String collector) {
            Preconditions.checkState((this.collector == null ? 1 : 0) != 0, (String)"collector is already set");
            this.collector = (String)Preconditions.checkNotNull((Object)collector, (String)"collector is required");
            return this;
        }
    }

    static interface TimeBuilderCollectorStage {
        @CheckReturnValue
        public TimeBuildStage collector(String var1);
    }

    static interface TimeBuildStage {
        public void build(Gauge<?> var1);

        public MetricName buildMetricName();
    }

    private final class CountBuilder
    implements CountBuilderCollectorStage,
    CountBuildStage {
        private String collector;

        private CountBuilder() {
        }

        @Override
        public void build(Gauge<?> gauge) {
            JvmGcMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.gc.count").putSafeTags("collector", this.collector).putSafeTags("libraryName", JvmGcMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build();
        }

        @Override
        public CountBuilder collector(String collector) {
            Preconditions.checkState((this.collector == null ? 1 : 0) != 0, (String)"collector is already set");
            this.collector = (String)Preconditions.checkNotNull((Object)collector, (String)"collector is required");
            return this;
        }
    }

    static interface CountBuilderCollectorStage {
        @CheckReturnValue
        public CountBuildStage collector(String var1);
    }

    static interface CountBuildStage {
        public void build(Gauge<?> var1);

        public MetricName buildMetricName();
    }
}

