/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Gauge;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.Optional;

final class JvmMemoryPoolsMetrics {
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = Optional.ofNullable(JvmMemoryPoolsMetrics.class.getPackage().getImplementationVersion()).orElse("unknown");
    private final TaggedMetricRegistry registry;

    private JvmMemoryPoolsMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    public static JvmMemoryPoolsMetrics of(TaggedMetricRegistry registry) {
        return new JvmMemoryPoolsMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    MaxBuilderMemoryPoolStage max() {
        return new MaxBuilder();
    }

    @CheckReturnValue
    UsedBuilderMemoryPoolStage used() {
        return new UsedBuilder();
    }

    @CheckReturnValue
    CommittedBuilderMemoryPoolStage committed() {
        return new CommittedBuilder();
    }

    @CheckReturnValue
    InitBuilderMemoryPoolStage init() {
        return new InitBuilder();
    }

    @CheckReturnValue
    UsageBuilderMemoryPoolStage usage() {
        return new UsageBuilder();
    }

    @CheckReturnValue
    UsedAfterGcBuilderMemoryPoolStage usedAfterGc() {
        return new UsedAfterGcBuilder();
    }

    public String toString() {
        return "JvmMemoryPoolsMetrics{registry=" + this.registry + "}";
    }

    private final class UsedAfterGcBuilder
    implements UsedAfterGcBuilderMemoryPoolStage,
    UsedAfterGcBuildStage {
        private String memoryPool;

        private UsedAfterGcBuilder() {
        }

        @Override
        public void build(Gauge<?> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.used-after-gc").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build();
        }

        @Override
        public UsedAfterGcBuilder memoryPool(String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }
    }

    static interface UsedAfterGcBuilderMemoryPoolStage {
        @CheckReturnValue
        public UsedAfterGcBuildStage memoryPool(String var1);
    }

    static interface UsedAfterGcBuildStage {
        public void build(Gauge<?> var1);

        public MetricName buildMetricName();
    }

    private final class UsageBuilder
    implements UsageBuilderMemoryPoolStage,
    UsageBuildStage {
        private String memoryPool;

        private UsageBuilder() {
        }

        @Override
        public void build(Gauge<?> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.usage").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build();
        }

        @Override
        public UsageBuilder memoryPool(String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }
    }

    static interface UsageBuilderMemoryPoolStage {
        @CheckReturnValue
        public UsageBuildStage memoryPool(String var1);
    }

    static interface UsageBuildStage {
        public void build(Gauge<?> var1);

        public MetricName buildMetricName();
    }

    private final class InitBuilder
    implements InitBuilderMemoryPoolStage,
    InitBuildStage {
        private String memoryPool;

        private InitBuilder() {
        }

        @Override
        public void build(Gauge<?> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.init").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build();
        }

        @Override
        public InitBuilder memoryPool(String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }
    }

    static interface InitBuilderMemoryPoolStage {
        @CheckReturnValue
        public InitBuildStage memoryPool(String var1);
    }

    static interface InitBuildStage {
        public void build(Gauge<?> var1);

        public MetricName buildMetricName();
    }

    private final class CommittedBuilder
    implements CommittedBuilderMemoryPoolStage,
    CommittedBuildStage {
        private String memoryPool;

        private CommittedBuilder() {
        }

        @Override
        public void build(Gauge<?> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.committed").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build();
        }

        @Override
        public CommittedBuilder memoryPool(String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }
    }

    static interface CommittedBuilderMemoryPoolStage {
        @CheckReturnValue
        public CommittedBuildStage memoryPool(String var1);
    }

    static interface CommittedBuildStage {
        public void build(Gauge<?> var1);

        public MetricName buildMetricName();
    }

    private final class UsedBuilder
    implements UsedBuilderMemoryPoolStage,
    UsedBuildStage {
        private String memoryPool;

        private UsedBuilder() {
        }

        @Override
        public void build(Gauge<?> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.used").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build();
        }

        @Override
        public UsedBuilder memoryPool(String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }
    }

    static interface UsedBuilderMemoryPoolStage {
        @CheckReturnValue
        public UsedBuildStage memoryPool(String var1);
    }

    static interface UsedBuildStage {
        public void build(Gauge<?> var1);

        public MetricName buildMetricName();
    }

    private final class MaxBuilder
    implements MaxBuilderMemoryPoolStage,
    MaxBuildStage {
        private String memoryPool;

        private MaxBuilder() {
        }

        @Override
        public void build(Gauge<?> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.max").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build();
        }

        @Override
        public MaxBuilder memoryPool(String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }
    }

    static interface MaxBuilderMemoryPoolStage {
        @CheckReturnValue
        public MaxBuildStage memoryPool(String var1);
    }

    static interface MaxBuildStage {
        public void build(Gauge<?> var1);

        public MetricName buildMetricName();
    }
}

