/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tritium.metrics.CacheMetricSet;
import com.palantir.tritium.metrics.CacheTaggedMetrics;
import com.palantir.tritium.metrics.ExecutorMetrics;
import com.palantir.tritium.metrics.GarbageCollectorMetrics;
import com.palantir.tritium.metrics.InstrumentedSslContext;
import com.palantir.tritium.metrics.InstrumentedSslEngine;
import com.palantir.tritium.metrics.InstrumentedSslSocketFactory;
import com.palantir.tritium.metrics.MemoryPoolMetrics;
import com.palantir.tritium.metrics.MetricBuilder;
import com.palantir.tritium.metrics.MetricRegistryWithReservoirs;
import com.palantir.tritium.metrics.Reservoirs;
import com.palantir.tritium.metrics.TaggedMetricsExecutorService;
import com.palantir.tritium.metrics.TaggedMetricsScheduledExecutorService;
import com.palantir.tritium.metrics.TaggedMetricsThreadFactory;
import com.palantir.tritium.metrics.TlsMetrics;
import com.palantir.tritium.metrics.registry.LockFreeExponentiallyDecayingReservoir;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;

public final class MetricRegistries {
    private static final SafeLogger log = SafeLoggerFactory.get(MetricRegistries.class);
    static final String RESERVOIR_TYPE_METRIC_NAME = MetricRegistry.name(MetricRegistries.class, (String[])new String[]{"reservoir.type"});

    private MetricRegistries() {
    }

    public static MetricRegistry createWithHdrHistogramReservoirs() {
        return MetricRegistries.createWithReservoirType(Reservoirs::hdrHistogramReservoir);
    }

    public static MetricRegistry createWithSlidingTimeWindowReservoirs(long window, TimeUnit windowUnit) {
        return MetricRegistries.createWithReservoirType(() -> Reservoirs.slidingTimeWindowArrayReservoir(window, windowUnit));
    }

    public static MetricRegistry createWithLockFreeExponentiallyDecayingReservoirs() {
        return MetricRegistries.createWithReservoirType(() -> LockFreeExponentiallyDecayingReservoir.builder().build());
    }

    @VisibleForTesting
    static MetricRegistry createWithReservoirType(Supplier<Reservoir> reservoirSupplier) {
        MetricRegistryWithReservoirs metrics = new MetricRegistryWithReservoirs(reservoirSupplier);
        String name = reservoirSupplier.get().getClass().getCanonicalName();
        MetricRegistries.registerSafe(metrics, RESERVOIR_TYPE_METRIC_NAME, () -> name);
        MetricRegistries.registerDefaultMetrics(metrics);
        return metrics;
    }

    private static void registerDefaultMetrics(MetricRegistry metrics) {
        MetricRegistries.registerSafe(metrics, MetricRegistry.name((String)MetricRegistries.class.getPackage().getName(), (String[])new String[]{"snapshot", "begin"}), new Gauge<String>(){
            private final String start = MetricRegistries.nowIsoTimestamp();

            public String getValue() {
                return this.start;
            }
        });
        MetricRegistries.registerSafe(metrics, MetricRegistry.name((String)MetricRegistries.class.getPackage().getName(), (String[])new String[]{"snapshot", "now"}), MetricRegistries::nowIsoTimestamp);
    }

    @VisibleForTesting
    static String nowIsoTimestamp() {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.UTC));
    }

    static <T extends Metric> T getOrAdd(MetricRegistry metrics, String name, MetricBuilder<T> builder) {
        Metric existingMetric = MetricRegistries.tryGetExistingMetric(metrics, name);
        if (existingMetric == null) {
            return MetricRegistries.addMetric(metrics, name, builder);
        }
        return MetricRegistries.getAndCheckExistingMetric(name, builder, existingMetric);
    }

    @Nullable
    private static Metric tryGetExistingMetric(MetricRegistry metrics, String name) {
        return (Metric)((MetricRegistry)Preconditions.checkNotNull((Object)metrics, (String)"metrics")).getMetrics().get(Preconditions.checkNotNull((Object)name));
    }

    private static <T extends Metric> T addMetric(MetricRegistry metrics, String name, MetricBuilder<T> builder) {
        Preconditions.checkNotNull(builder);
        T newMetric = builder.newMetric();
        try {
            return (T)metrics.register(name, newMetric);
        }
        catch (IllegalArgumentException e) {
            Metric existingMetric = (Metric)metrics.getMetrics().get(name);
            return MetricRegistries.getAndCheckExistingMetric(name, builder, existingMetric);
        }
    }

    private static <T extends Metric> T getAndCheckExistingMetric(String name, MetricBuilder<T> builder, @Nullable Metric existingMetric) {
        if (existingMetric != null && builder.isInstance(existingMetric)) {
            return (T)existingMetric;
        }
        throw MetricRegistries.invalidMetric(name, existingMetric, builder.newMetric());
    }

    private static SafeIllegalArgumentException invalidMetric(String name, @Nullable Metric existingMetric, Metric newMetric) {
        throw new SafeIllegalArgumentException("Metric name already used for different metric type", new Arg[]{SafeArg.of((String)"metricName", (Object)name), SafeArg.of((String)"existingMetricType", (Object)MetricRegistries.safeClassName(existingMetric)), SafeArg.of((String)"newMetricType", (Object)MetricRegistries.safeClassName(newMetric))});
    }

    private static String safeClassName(@Nullable Object obj) {
        return obj == null ? "" : obj.getClass().getName();
    }

    public static MetricFilter metricsPrefixedBy(String prefix) {
        Preconditions.checkNotNull((Object)prefix, (String)"prefix");
        return (name, _metric) -> name.startsWith(prefix);
    }

    public static SortedMap<String, Metric> metricsMatching(MetricRegistry metrics, MetricFilter filter) {
        TreeMap<String, Metric> matchingMetrics = new TreeMap<String, Metric>();
        metrics.getMetrics().forEach((key, value) -> {
            if (filter.matches(key, value)) {
                matchingMetrics.put((String)key, (Metric)value);
            }
        });
        return matchingMetrics;
    }

    @Deprecated
    public static void registerCache(MetricRegistry registry, Cache<?, ?> cache, String name) {
        MetricRegistries.registerCache(registry, cache, name, Clock.defaultClock());
    }

    @VisibleForTesting
    static void registerCache(MetricRegistry registry, Cache<?, ?> cache, String name, Clock clock) {
        Preconditions.checkNotNull((Object)registry, (String)"metric registry");
        Preconditions.checkNotNull(cache, (String)"cache");
        Preconditions.checkNotNull((Object)name, (String)"name");
        Preconditions.checkNotNull((Object)clock, (String)"clock");
        Preconditions.checkArgument((!name.trim().isEmpty() ? 1 : 0) != 0, (String)"Cache name cannot be blank or empty");
        CacheMetricSet.create(cache, name).getMetrics().forEach((key, value) -> MetricRegistries.registerWithReplacement(registry, key, value));
    }

    public static void registerCache(TaggedMetricRegistry registry, Cache<?, ?> cache, @Safe String name) {
        Preconditions.checkNotNull((Object)registry, (String)"metric registry");
        Preconditions.checkNotNull(cache, (String)"cache");
        Preconditions.checkNotNull((Object)name, (String)"name");
        Preconditions.checkArgument((!name.trim().isEmpty() ? 1 : 0) != 0, (String)"Cache name cannot be blank or empty");
        CacheTaggedMetrics.create(cache, name).getMetrics().forEach((arg_0, arg_1) -> ((TaggedMetricRegistry)registry).registerWithReplacement(arg_0, arg_1));
    }

    public static void registerGarbageCollection(TaggedMetricRegistry registry) {
        GarbageCollectorMetrics.register((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry is required"));
    }

    public static void registerMemoryPools(TaggedMetricRegistry registry) {
        MemoryPoolMetrics.register((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry is required"));
    }

    public static ScheduledExecutorService instrument(TaggedMetricRegistry registry, ScheduledExecutorService delegate, String name) {
        return new TaggedMetricsScheduledExecutorService((ScheduledExecutorService)Preconditions.checkNotNull((Object)delegate, (String)"delegate"), ExecutorMetrics.of(registry), (String)Preconditions.checkNotNull((Object)name, (String)"name"));
    }

    public static ExecutorService instrument(TaggedMetricRegistry registry, ExecutorService delegate, String name) {
        return MetricRegistries.executor().registry(registry).name(name).executor(delegate).build();
    }

    public static ThreadFactory instrument(TaggedMetricRegistry registry, ThreadFactory delegate, String name) {
        return new TaggedMetricsThreadFactory((ThreadFactory)Preconditions.checkNotNull((Object)delegate, (String)"ThreadFactory is required"), ExecutorMetrics.of(registry), (String)Preconditions.checkNotNull((Object)name, (String)"Name is required"));
    }

    public static SSLContext instrument(TaggedMetricRegistry registry, SSLContext context, String name) {
        return new InstrumentedSslContext((SSLContext)Preconditions.checkNotNull((Object)context, (String)"context"), TlsMetrics.of(registry), (String)Preconditions.checkNotNull((Object)name, (String)"name"));
    }

    public static SSLSocketFactory instrument(TaggedMetricRegistry registry, SSLSocketFactory factory, String name) {
        return new InstrumentedSslSocketFactory((SSLSocketFactory)Preconditions.checkNotNull((Object)factory, (String)"factory"), TlsMetrics.of(registry), (String)Preconditions.checkNotNull((Object)name, (String)"name"));
    }

    public static SSLEngine unwrap(SSLEngine engine) {
        return InstrumentedSslEngine.extractDelegate((SSLEngine)Preconditions.checkNotNull((Object)engine, (String)"engine"));
    }

    public static <T extends Metric> T registerSafe(MetricRegistry registry, String name, T metric) {
        return MetricRegistries.registerOrReplace(registry, name, metric, false);
    }

    public static <T extends Metric> T registerWithReplacement(MetricRegistry registry, String name, T metric) {
        return MetricRegistries.registerOrReplace(registry, name, metric, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Metric> T registerOrReplace(MetricRegistry registry, String name, T metric, boolean replace) {
        MetricRegistry metricRegistry = registry;
        synchronized (metricRegistry) {
            Map metrics = registry.getMetrics();
            Metric existingMetric = (Metric)metrics.get(name);
            if (existingMetric == null) {
                return (T)registry.register(name, metric);
            }
            Set existingMetricInterfaces = Collections.newSetFromMap(new IdentityHashMap());
            existingMetricInterfaces.addAll(Arrays.asList(existingMetric.getClass().getInterfaces()));
            Set newMetricInterfaces = Collections.newSetFromMap(new IdentityHashMap());
            newMetricInterfaces.addAll(Arrays.asList(metric.getClass().getInterfaces()));
            if (!existingMetricInterfaces.equals(newMetricInterfaces)) {
                throw new SafeIllegalArgumentException("Metric already registered at this name that implements a different set of interfaces", new Arg[]{SafeArg.of((String)"name", (Object)name), SafeArg.of((String)"existingMetric", (Object)String.valueOf(existingMetric))});
            }
            if (replace && registry.remove(name)) {
                log.info("Removed existing registered metric with name {}: {}", (Arg)SafeArg.of((String)"name", (Object)name), (Arg)SafeArg.of((String)"existingMetric", (Object)String.valueOf(existingMetric)));
                registry.register(name, metric);
                return metric;
            }
            log.warn("Metric already registered at this name. Name: {}, existing metric: {}", (Arg)SafeArg.of((String)"name", (Object)name), (Arg)SafeArg.of((String)"existingMetric", (Object)String.valueOf(existingMetric)));
            Metric registeredMetric = existingMetric;
            return (T)registeredMetric;
        }
    }

    public static void registerAll(TaggedMetricRegistry registry, String prefix, MetricSet metricSet) {
        Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry is required");
        Preconditions.checkNotNull((Object)prefix, (String)"Prefix is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)prefix) ? 1 : 0) != 0, (String)"Prefix cannot be blank");
        Preconditions.checkNotNull((Object)metricSet, (String)"MetricSet is required");
        metricSet.getMetrics().forEach((name, metric) -> {
            String safeName = MetricRegistry.name((String)prefix, (String[])new String[]{name});
            MetricName metricName = MetricName.builder().safeName(safeName).build();
            if (metric instanceof Gauge) {
                registry.registerWithReplacement(metricName, (Gauge)metric);
            } else if (metric instanceof Counter) {
                registry.counter(metricName, () -> (Counter)metric);
            } else if (metric instanceof Histogram) {
                registry.histogram(metricName, () -> (Histogram)metric);
            } else if (metric instanceof Meter) {
                registry.meter(metricName, () -> (Meter)metric);
            } else if (metric instanceof Timer) {
                registry.timer(metricName, () -> (Timer)metric);
            } else if (metric instanceof MetricSet) {
                MetricRegistries.registerAll(registry, safeName, (MetricSet)metric);
            } else {
                throw new SafeIllegalArgumentException("Unknown Metric Type", new Arg[]{SafeArg.of((String)"type", metric.getClass())});
            }
        });
    }

    @CheckReturnValue
    public static ExecutorInstrumentationBuilderRegistryStage executor() {
        return new ExecutorInstrumentationBuilder();
    }

    public static interface ExecutorInstrumentationBuilderFinalStage {
        @CheckReturnValue
        public ExecutorInstrumentationBuilderFinalStage reportQueuedDuration(boolean var1);

        @CheckReturnValue
        public ExecutorService build();
    }

    public static interface ExecutorInstrumentationBuilderExecutorStage {
        @CheckReturnValue
        public ExecutorInstrumentationBuilderFinalStage executor(ExecutorService var1);
    }

    public static interface ExecutorInstrumentationBuilderNameStage {
        @CheckReturnValue
        public ExecutorInstrumentationBuilderExecutorStage name(String var1);
    }

    public static interface ExecutorInstrumentationBuilderRegistryStage {
        @CheckReturnValue
        public ExecutorInstrumentationBuilderNameStage registry(TaggedMetricRegistry var1);
    }

    private static final class ExecutorInstrumentationBuilder
    implements ExecutorInstrumentationBuilderRegistryStage,
    ExecutorInstrumentationBuilderNameStage,
    ExecutorInstrumentationBuilderExecutorStage,
    ExecutorInstrumentationBuilderFinalStage {
        @Nullable
        private TaggedMetricRegistry registry;
        @Nullable
        private String name;
        @Nullable
        private ExecutorService executor;
        private boolean reportQueuedDuration = true;

        private ExecutorInstrumentationBuilder() {
        }

        @Override
        @CheckReturnValue
        public ExecutorInstrumentationBuilderNameStage registry(TaggedMetricRegistry value) {
            this.registry = (TaggedMetricRegistry)Preconditions.checkNotNull((Object)value, (String)"TaggedMetricRegistry");
            return this;
        }

        @Override
        @CheckReturnValue
        public ExecutorInstrumentationBuilderExecutorStage name(String value) {
            this.name = (String)Preconditions.checkNotNull((Object)value, (String)"Name");
            return this;
        }

        @Override
        @CheckReturnValue
        public ExecutorInstrumentationBuilderFinalStage executor(ExecutorService value) {
            this.executor = (ExecutorService)Preconditions.checkNotNull((Object)value, (String)"ExecutorService");
            return this;
        }

        @Override
        @CheckReturnValue
        public ExecutorInstrumentationBuilderFinalStage reportQueuedDuration(boolean value) {
            this.reportQueuedDuration = value;
            return this;
        }

        @Override
        @CheckReturnValue
        public ExecutorService build() {
            if (this.executor instanceof ScheduledExecutorService) {
                return MetricRegistries.instrument((TaggedMetricRegistry)Preconditions.checkNotNull((Object)this.registry, (String)"delegate"), (ScheduledExecutorService)this.executor, (String)Preconditions.checkNotNull((Object)this.name, (String)"Name"));
            }
            return new TaggedMetricsExecutorService((ExecutorService)Preconditions.checkNotNull((Object)this.executor, (String)"delegate"), ExecutorMetrics.of((TaggedMetricRegistry)Preconditions.checkNotNull((Object)this.registry, (String)"registry")), (String)Preconditions.checkNotNull((Object)this.name, (String)"name"), this.reportQueuedDuration);
        }
    }
}

