/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import com.palantir.tritium.metrics.ExecutorMetrics;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class TaggedMetricsScheduledExecutorService
extends AbstractExecutorService
implements ScheduledExecutorService {
    private final ScheduledExecutorService delegate;
    private final String name;
    private final Counter running;
    private final Timer duration;
    private final Counter scheduledOverrun;

    TaggedMetricsScheduledExecutorService(ScheduledExecutorService delegate, ExecutorMetrics metrics, String name) {
        this.delegate = delegate;
        this.name = name;
        this.running = metrics.running(name);
        this.duration = metrics.duration(name);
        this.scheduledOverrun = metrics.scheduledOverrun(name);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.delegate.schedule(new TaggedMetricsRunnable(task), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(new TaggedMetricsCallable<V>(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(new TaggedMetricsScheduledRunnable(task, period, unit), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(new TaggedMetricsRunnable(task), initialDelay, delay, unit);
    }

    @Override
    public void execute(Runnable task) {
        this.delegate.execute(new TaggedMetricsRunnable(task));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(new TaggedMetricsCallable<T>(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(new TaggedMetricsRunnable(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(new TaggedMetricsRunnable(task));
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public String toString() {
        return "TaggedMetricsScheduledExecutorService{name=" + this.name + ", delegate='" + this.delegate + "'}";
    }

    private final class TaggedMetricsCallable<T>
    implements Callable<T> {
        private final Callable<T> task;

        TaggedMetricsCallable(Callable<T> task) {
            this.task = task;
        }

        @Override
        public T call() throws Exception {
            TaggedMetricsScheduledExecutorService.this.running.inc();
            try {
                T t;
                block9: {
                    Timer.Context ignored = TaggedMetricsScheduledExecutorService.this.duration.time();
                    try {
                        t = this.task.call();
                        if (ignored == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return t;
            }
            finally {
                TaggedMetricsScheduledExecutorService.this.running.dec();
            }
        }
    }

    private final class TaggedMetricsScheduledRunnable
    implements Runnable {
        private final Runnable task;
        private final long periodInNanos;

        TaggedMetricsScheduledRunnable(Runnable task, long period, TimeUnit unit) {
            this.task = task;
            this.periodInNanos = unit.toNanos(period);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaggedMetricsScheduledExecutorService.this.running.inc();
            Timer.Context context = TaggedMetricsScheduledExecutorService.this.duration.time();
            try {
                this.task.run();
            }
            finally {
                long elapsed = context.stop();
                TaggedMetricsScheduledExecutorService.this.running.dec();
                if (elapsed > this.periodInNanos) {
                    TaggedMetricsScheduledExecutorService.this.scheduledOverrun.inc();
                }
            }
        }
    }

    private final class TaggedMetricsRunnable
    implements Runnable {
        private final Runnable task;

        TaggedMetricsRunnable(Runnable task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaggedMetricsScheduledExecutorService.this.running.inc();
            try (Timer.Context ignored = TaggedMetricsScheduledExecutorService.this.duration.time();){
                this.task.run();
            }
            finally {
                TaggedMetricsScheduledExecutorService.this.running.dec();
            }
        }
    }
}

