/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.ExecutorMetrics;
import java.util.concurrent.ThreadFactory;

final class TaggedMetricsThreadFactory
implements ThreadFactory {
    private final ThreadFactory delegate;
    private final Meter created;
    private final Counter running;

    TaggedMetricsThreadFactory(ThreadFactory delegate, ExecutorMetrics metrics, String name) {
        this.delegate = (ThreadFactory)Preconditions.checkNotNull((Object)delegate, (String)"ThreadFactory is required");
        Preconditions.checkNotNull((Object)name, (String)"Name is required");
        Preconditions.checkNotNull((Object)metrics, (String)"ExecutorMetrics is required");
        this.created = metrics.threadsCreated(name);
        this.running = metrics.threadsRunning(name);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread result = this.delegate.newThread(new InstrumentedTask((Runnable)Preconditions.checkNotNull((Object)runnable, (String)"Runnable is required"), this.running));
        this.created.mark();
        return result;
    }

    public String toString() {
        return "TaggedMetricsThreadFactory{delegate=" + this.delegate + "}";
    }

    private static final class InstrumentedTask
    implements Runnable {
        private final Runnable delegate;
        private final Counter running;

        InstrumentedTask(Runnable delegate, Counter running) {
            this.delegate = delegate;
            this.running = running;
        }

        @Override
        public void run() {
            this.running.inc();
            try {
                this.delegate.run();
            }
            finally {
                this.running.dec();
            }
        }

        public String toString() {
            return "InstrumentedTask{delegate=" + this.delegate + "}";
        }
    }
}

