/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Meter;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.Optional;

final class TlsMetrics {
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = Optional.ofNullable(TlsMetrics.class.getPackage().getImplementationVersion()).orElse("unknown");
    private final TaggedMetricRegistry registry;

    private TlsMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    public static TlsMetrics of(TaggedMetricRegistry registry) {
        return new TlsMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    HandshakeBuilderContextStage handshake() {
        return new HandshakeBuilder();
    }

    public String toString() {
        return "TlsMetrics{registry=" + this.registry + "}";
    }

    private final class HandshakeBuilder
    implements HandshakeBuilderContextStage,
    HandshakeBuilderCipherStage,
    HandshakeBuilderProtocolStage,
    HandshakeBuildStage {
        private String context;
        private String cipher;
        private String protocol;

        private HandshakeBuilder() {
        }

        @Override
        public Meter build() {
            return TlsMetrics.this.registry.meter(MetricName.builder().safeName("tls.handshake").putSafeTags("context", this.context).putSafeTags("cipher", this.cipher).putSafeTags("protocol", this.protocol).putSafeTags("libraryName", TlsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).build());
        }

        @Override
        public HandshakeBuilder context(String context) {
            Preconditions.checkState((this.context == null ? 1 : 0) != 0, (String)"context is already set");
            this.context = (String)Preconditions.checkNotNull((Object)context, (String)"context is required");
            return this;
        }

        @Override
        public HandshakeBuilder cipher(String cipher) {
            Preconditions.checkState((this.cipher == null ? 1 : 0) != 0, (String)"cipher is already set");
            this.cipher = (String)Preconditions.checkNotNull((Object)cipher, (String)"cipher is required");
            return this;
        }

        @Override
        public HandshakeBuilder protocol(String protocol) {
            Preconditions.checkState((this.protocol == null ? 1 : 0) != 0, (String)"protocol is already set");
            this.protocol = (String)Preconditions.checkNotNull((Object)protocol, (String)"protocol is required");
            return this;
        }
    }

    static interface HandshakeBuilderProtocolStage {
        @CheckReturnValue
        public HandshakeBuildStage protocol(String var1);
    }

    static interface HandshakeBuilderCipherStage {
        @CheckReturnValue
        public HandshakeBuilderProtocolStage cipher(String var1);
    }

    static interface HandshakeBuilderContextStage {
        @CheckReturnValue
        public HandshakeBuilderCipherStage context(String var1);
    }

    static interface HandshakeBuildStage {
        @CheckReturnValue
        public Meter build();
    }
}

