/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class Proxies {
    private Proxies() {
        throw new UnsupportedOperationException();
    }

    public static <T, U extends T> T newProxy(Class<T> iface, U delegate, InvocationHandler handler) {
        Objects.requireNonNull(iface, "interface");
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(handler, "handler");
        Proxies.checkIsInterface(iface);
        return iface.cast(Proxy.newProxyInstance(delegate.getClass().getClassLoader(), Proxies.interfaces(iface, delegate.getClass()), handler));
    }

    static Class<?>[] interfaces(Class<?> iface, Class<?> delegateClass, Collection<Class<?>> additionalInterfaces) {
        Proxies.checkIsInterface(iface);
        Objects.requireNonNull(additionalInterfaces, "additionalInterfaces");
        Objects.requireNonNull(delegateClass, "delegateClass");
        LinkedHashSet interfaces = new LinkedHashSet();
        interfaces.add(iface);
        interfaces.addAll(additionalInterfaces);
        if (delegateClass.isInterface()) {
            interfaces.add(delegateClass);
        }
        interfaces.addAll(Arrays.asList(delegateClass.getInterfaces()));
        Proxies.checkAreAllInterfaces(interfaces);
        return interfaces.toArray(new Class[0]);
    }

    static Class<?>[] interfaces(Class<?> iface, Class<?> delegateClass) {
        return Proxies.interfaces(iface, delegateClass, Collections.emptySet());
    }

    static void checkIsInterface(Class<?> iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
    }

    static void checkAreAllInterfaces(Set<Class<?>> interfaces) {
        for (Class<?> possibleInterface : interfaces) {
            Proxies.checkIsInterface(possibleInterface);
        }
    }
}

