/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.palantir.logsafe.Preconditions;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.Nullable;

final class ExtraEntrySortedMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V> {
    private final Ordering<? super K> ordering;
    private final SortedMap<K, V> base;
    private final K extraKey;
    private final V extraValue;
    private final int extraEntryHashCode;

    ExtraEntrySortedMap(SortedMap<K, V> base, K extraKey, V extraValue) {
        this.base = (SortedMap)Preconditions.checkNotNull(base, (String)"base");
        this.extraKey = Preconditions.checkNotNull(extraKey, (String)"extraKey");
        this.extraValue = Preconditions.checkNotNull(extraValue, (String)"extraValue");
        this.ordering = Ordering.from(base.comparator());
        this.extraEntryHashCode = Maps.immutableEntry(extraKey, extraValue).hashCode();
        Preconditions.checkArgument((!base.containsKey(extraKey) ? 1 : 0) != 0, (String)"Base must not contain the extra key that is to be added");
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.base.comparator();
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        SortedMap<K, V> newBase = this.base.subMap(fromKey, toKey);
        if (this.ordering.compare(fromKey, this.extraKey) <= 0 && this.ordering.compare(toKey, this.extraKey) > 0) {
            return new ExtraEntrySortedMap<K, V>(newBase, this.extraKey, this.extraValue);
        }
        return newBase;
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        SortedMap<K, V> newBase = this.base.headMap(toKey);
        if (this.ordering.compare(toKey, this.extraKey) > 0) {
            return new ExtraEntrySortedMap<K, V>(newBase, this.extraKey, this.extraValue);
        }
        return newBase;
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        SortedMap<K, V> newBase = this.base.tailMap(fromKey);
        if (this.ordering.compare(fromKey, this.extraKey) <= 0) {
            return new ExtraEntrySortedMap<K, V>(newBase, this.extraKey, this.extraValue);
        }
        return newBase;
    }

    @Override
    public K firstKey() {
        if (this.base.isEmpty()) {
            return this.extraKey;
        }
        return (K)this.ordering.min(this.base.firstKey(), this.extraKey);
    }

    @Override
    public K lastKey() {
        if (this.base.isEmpty()) {
            return this.extraKey;
        }
        return (K)this.ordering.max(this.base.lastKey(), this.extraKey);
    }

    @Override
    public int size() {
        return this.base.size() + 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.extraKey.equals(key) || this.base.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.extraValue.equals(value) || this.base.containsValue(value);
    }

    @Override
    @Nullable
    public V get(Object key) {
        if (this.extraKey.equals(key)) {
            return this.extraValue;
        }
        return this.base.get(key);
    }

    @Override
    public V put(K _key, V _value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object _key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> _other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return Iterables.mergeSorted((Iterable)ImmutableList.of(ExtraEntrySortedMap.this.base.keySet(), (Object)ImmutableList.of(ExtraEntrySortedMap.this.extraKey)), ExtraEntrySortedMap.this.ordering).iterator();
            }

            @Override
            public int size() {
                return ExtraEntrySortedMap.this.base.size() + 1;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return Iterators.transform(ExtraEntrySortedMap.this.keySet().iterator(), key -> ExtraEntrySortedMap.this.get(key));
            }

            @Override
            public int size() {
                return ExtraEntrySortedMap.this.base.values().size() + 1;
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return Iterators.transform(ExtraEntrySortedMap.this.keySet().iterator(), key -> Maps.immutableEntry((Object)key, ExtraEntrySortedMap.this.get(key)));
            }

            @Override
            public int size() {
                return ExtraEntrySortedMap.this.base.size() + 1;
            }
        };
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other instanceof ExtraEntrySortedMap) {
            ExtraEntrySortedMap otherMap = (ExtraEntrySortedMap)other;
            if (this.extraKey.equals(otherMap.extraKey) && this.extraValue.equals(otherMap.extraValue)) {
                return this.base.equals(otherMap.base);
            }
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return this.base.hashCode() + this.extraEntryHashCode;
    }
}

