/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.registry;

import com.google.common.collect.ImmutableSortedMap;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.registry.ExtraEntrySortedMap;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.PrehashedSortedMap;
import java.util.SortedMap;
import javax.annotation.Nullable;

final class RealMetricName
implements MetricName {
    private static final SortedMap<String, String> EMPTY = RealMetricName.prehash(ImmutableSortedMap.of());
    private final String safeName;
    private final SortedMap<String, String> safeTags;
    private final int hashCode;

    private RealMetricName(String safeName, SortedMap<String, String> safeTags) {
        this.safeName = safeName;
        this.safeTags = safeTags;
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int hash = 5381;
        hash += (hash << 5) + this.safeName().hashCode();
        hash += (hash << 5) + this.safeTags().hashCode();
        return hash;
    }

    @Override
    public String safeName() {
        return this.safeName;
    }

    @Override
    public SortedMap<String, String> safeTags() {
        return this.safeTags;
    }

    public String toString() {
        return "MetricName{safeName=" + this.safeName + ", safeTags=" + this.safeTags + "}";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof MetricName)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        MetricName otherMetric = (MetricName)other;
        return this.safeName().equals(otherMetric.safeName()) && this.safeTags().equals(otherMetric.safeTags());
    }

    static MetricName create(String safeName) {
        return new RealMetricName((String)Preconditions.checkNotNull((Object)safeName, (String)"safeName"), EMPTY);
    }

    static MetricName create(MetricName other) {
        return new RealMetricName(other.safeName(), RealMetricName.prehash(other.safeTags()));
    }

    static MetricName create(MetricName other, String extraTagName, String extraTagValue) {
        return new RealMetricName(other.safeName(), new ExtraEntrySortedMap<String, String>(RealMetricName.prehash(other.safeTags()), extraTagName, extraTagValue));
    }

    private static <K, V> SortedMap<K, V> prehash(SortedMap<K, V> map) {
        if (map instanceof PrehashedSortedMap) {
            return map;
        }
        return new PrehashedSortedMap(ImmutableSortedMap.copyOfSorted(map));
    }
}

