/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.registry;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.RealMetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import com.palantir.tritium.metrics.registry.TaggedMetricSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaggedMetricRegistry
implements TaggedMetricRegistry {
    private static final Supplier<Logger> log = Suppliers.memoize(() -> LoggerFactory.getLogger(AbstractTaggedMetricRegistry.class));
    private final Map<MetricName, Metric> registry = new ConcurrentHashMap<MetricName, Metric>();
    private final Map<Map.Entry<String, String>, TaggedMetricSet> taggedRegistries = new ConcurrentHashMap<Map.Entry<String, String>, TaggedMetricSet>();
    private final Supplier<Reservoir> reservoirSupplier;

    public AbstractTaggedMetricRegistry(Supplier<Reservoir> reservoirSupplier) {
        this.reservoirSupplier = (Supplier)Preconditions.checkNotNull(reservoirSupplier, (String)"reservoirSupplier");
    }

    @Nonnull
    protected Supplier<Counter> counterSupplier() {
        return Counter::new;
    }

    @Nonnull
    protected Supplier<Histogram> histogramSupplier() {
        return () -> new Histogram(this.createReservoir());
    }

    @Nonnull
    protected Supplier<Meter> meterSupplier() {
        return Meter::new;
    }

    @Nonnull
    protected Supplier<Timer> timerSupplier() {
        return () -> new Timer(this.createReservoir());
    }

    @Nonnull
    protected final Reservoir createReservoir() {
        return this.reservoirSupplier.get();
    }

    @Override
    public final Counter counter(MetricName metricName) {
        return this.counter(metricName, this.counterSupplier());
    }

    @Override
    public final Counter counter(MetricName metricName, Supplier<Counter> counterSupplier) {
        return this.getOrAdd(metricName, Counter.class, counterSupplier);
    }

    @Override
    public final <T> Optional<Gauge<T>> gauge(MetricName metricName) {
        return Optional.ofNullable(AbstractTaggedMetricRegistry.checkMetricType(metricName, Gauge.class, this.registry.get(metricName)));
    }

    @Override
    public final <T> Gauge<T> gauge(MetricName metricName, Gauge<T> gauge) {
        return this.getOrAdd(metricName, Gauge.class, () -> gauge);
    }

    @Override
    public final void registerWithReplacement(MetricName metricName, Gauge<?> gauge) {
        Metric existing = (Metric)this.registry.put(metricName, (Metric)gauge);
        if (existing instanceof Gauge) {
            log.get().debug("Removed previously registered gauge {}", (Object)SafeArg.of((String)"metricName", (Object)metricName));
        } else if (existing != null) {
            this.registry.replace(metricName, existing);
            throw AbstractTaggedMetricRegistry.invalidMetric(metricName, gauge.getClass(), existing);
        }
    }

    @Override
    public final Histogram histogram(MetricName metricName) {
        return this.histogram(metricName, this.histogramSupplier());
    }

    @Override
    public final Histogram histogram(MetricName metricName, Supplier<Histogram> histogramSupplier) {
        return this.getOrAdd(metricName, Histogram.class, histogramSupplier);
    }

    @Override
    public final Meter meter(MetricName metricName) {
        return this.meter(metricName, this.meterSupplier());
    }

    @Override
    public final Meter meter(MetricName metricName, Supplier<Meter> meterSupplier) {
        return this.getOrAdd(metricName, Meter.class, meterSupplier);
    }

    @Override
    public final Timer timer(MetricName metricName) {
        return this.timer(metricName, this.timerSupplier());
    }

    @Override
    public final Timer timer(MetricName metricName, Supplier<Timer> timerSupplier) {
        return this.getOrAdd(metricName, Timer.class, timerSupplier);
    }

    @Override
    public final Map<MetricName, Metric> getMetrics() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        result.putAll(this.registry);
        this.taggedRegistries.forEach((tag, metrics) -> metrics.getMetrics().forEach((metricName, metric) -> result.put((Object)RealMetricName.create(metricName, (String)tag.getKey(), (String)tag.getValue()), metric)));
        return result.build();
    }

    @Override
    public final void forEachMetric(BiConsumer<MetricName, Metric> consumer) {
        this.registry.forEach(consumer);
        this.taggedRegistries.forEach((tag, metrics) -> metrics.forEachMetric((metricName, metric) -> consumer.accept(RealMetricName.create(metricName, (String)tag.getKey(), (String)tag.getValue()), (Metric)metric)));
    }

    @Override
    public final Optional<Metric> remove(MetricName metricName) {
        return Optional.ofNullable(this.registry.remove(metricName));
    }

    @Override
    public final void addMetrics(String safeTagName, String safeTagValue, TaggedMetricSet other) {
        this.taggedRegistries.put(Maps.immutableEntry((Object)safeTagName, (Object)safeTagValue), other);
    }

    @Override
    public final Optional<TaggedMetricSet> removeMetrics(String safeTagName, String safeTagValue) {
        return Optional.ofNullable(this.taggedRegistries.remove(Maps.immutableEntry((Object)safeTagName, (Object)safeTagValue)));
    }

    @Override
    public final boolean removeMetrics(String safeTagName, String safeTagValue, TaggedMetricSet metrics) {
        return this.taggedRegistries.remove(Maps.immutableEntry((Object)safeTagName, (Object)safeTagValue), metrics);
    }

    protected final <T extends Metric> T getOrAdd(MetricName metricName, Class<T> metricClass, Supplier<T> metricSupplier) {
        Metric metric = this.registry.computeIfAbsent(metricName, _name -> (Metric)metricSupplier.get());
        return (T)((Metric)Preconditions.checkNotNull(AbstractTaggedMetricRegistry.checkMetricType(metricName, metricClass, metric), (String)"metric"));
    }

    @Nullable
    static <T extends Metric> T checkMetricType(MetricName metricName, Class<T> metricClass, @Nullable Metric metric) {
        if (metric == null || metricClass.isInstance(metric)) {
            return (T)((Metric)metricClass.cast(metric));
        }
        throw AbstractTaggedMetricRegistry.invalidMetric(metricName, metricClass, metric);
    }

    private static <T extends Metric> SafeIllegalArgumentException invalidMetric(MetricName metricName, Class<T> metricClass, Metric metric) {
        return new SafeIllegalArgumentException("Metric name already used for different metric type", new Arg[]{SafeArg.of((String)"metricName", (Object)metricName.safeName()), SafeArg.of((String)"existingMetricType", (Object)metric.getClass().getSimpleName()), SafeArg.of((String)"newMetricType", (Object)metricClass.getSimpleName()), SafeArg.of((String)"safeTags", metricName.safeTags())});
    }
}

