/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.registry;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.tritium.metrics.registry.MetricName;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetricName", generator="Immutables")
@Immutable
final class ImmutableMetricName
implements MetricName {
    private final String safeName;
    private final ImmutableSortedMap<String, String> safeTags;

    private ImmutableMetricName(String safeName, ImmutableSortedMap<String, String> safeTags) {
        this.safeName = safeName;
        this.safeTags = safeTags;
    }

    @Override
    public String safeName() {
        return this.safeName;
    }

    public ImmutableSortedMap<String, String> safeTags() {
        return this.safeTags;
    }

    public final ImmutableMetricName withSafeName(String value) {
        String newValue = Objects.requireNonNull(value, "safeName");
        if (this.safeName.equals(newValue)) {
            return this;
        }
        return new ImmutableMetricName(newValue, this.safeTags);
    }

    public final ImmutableMetricName withSafeTags(Map<String, ? extends String> entries) {
        if (this.safeTags == entries) {
            return this;
        }
        ImmutableSortedMap newValue = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural());
        return new ImmutableMetricName(this.safeName, (ImmutableSortedMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetricName && this.equalTo((ImmutableMetricName)another);
    }

    private boolean equalTo(ImmutableMetricName another) {
        return this.safeName.equals(another.safeName) && this.safeTags.equals(another.safeTags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.safeName.hashCode();
        h += (h << 5) + this.safeTags.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetricName").omitNullValues().add("safeName", (Object)this.safeName).add("safeTags", this.safeTags).toString();
    }

    public static MetricName copyOf(MetricName instance) {
        if (instance instanceof ImmutableMetricName) {
            return (ImmutableMetricName)instance;
        }
        return new MetricName.Builder().from(instance).build();
    }

    @Generated(from="MetricName", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_SAFE_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String safeName;
        private ImmutableSortedMap.Builder<String, String> safeTags = ImmutableSortedMap.naturalOrder();

        public Builder() {
            if (!(this instanceof MetricName.Builder)) {
                throw new UnsupportedOperationException("Use: new MetricName.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MetricName.Builder from(MetricName instance) {
            Objects.requireNonNull(instance, "instance");
            this.safeName(instance.safeName());
            this.putAllSafeTags(instance.safeTags());
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MetricName.Builder safeName(String safeName) {
            this.safeName = Objects.requireNonNull(safeName, "safeName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MetricName.Builder putSafeTags(String key, String value) {
            this.safeTags.put((Object)key, (Object)value);
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MetricName.Builder putSafeTags(Map.Entry<String, ? extends String> entry) {
            this.safeTags.put(entry);
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MetricName.Builder safeTags(Map<String, ? extends String> entries) {
            this.safeTags = ImmutableSortedMap.naturalOrder();
            return this.putAllSafeTags(entries);
        }

        @CanIgnoreReturnValue
        public final MetricName.Builder putAllSafeTags(Map<String, ? extends String> entries) {
            this.safeTags.putAll(entries);
            return (MetricName.Builder)this;
        }

        public MetricName build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMetricName(this.safeName, (ImmutableSortedMap<String, String>)this.safeTags.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("safeName");
            }
            return "Cannot build MetricName, some of required attributes are not set " + attributes;
        }
    }
}

