/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event.log;

import com.google.common.collect.ImmutableList;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.tritium.api.functions.BooleanSupplier;
import com.palantir.tritium.api.functions.LongPredicate;
import com.palantir.tritium.event.AbstractInvocationEventHandler;
import com.palantir.tritium.event.DefaultInvocationContext;
import com.palantir.tritium.event.InvocationContext;
import com.palantir.tritium.event.log.LoggingLevel;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class LoggingInvocationEventHandler
extends AbstractInvocationEventHandler<InvocationContext> {
    private static final List<String> MESSAGE_PATTERNS = LoggingInvocationEventHandler.generateMessagePatterns(20);
    public static final LongPredicate LOG_ALL_DURATIONS = LongPredicate.TRUE;
    public static final LongPredicate LOG_DURATIONS_GREATER_THAN_1_MICROSECOND = nanos -> TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 1L;
    public static final LongPredicate LOG_DURATIONS_GREATER_THAN_0_MILLIS = nanos -> TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L;
    public static final LongPredicate NEVER_LOG = LongPredicate.FALSE;
    private final Logger logger;
    private final LoggingLevel level;
    private final java.util.function.LongPredicate durationPredicate;

    public LoggingInvocationEventHandler(Logger logger, LoggingLevel level) {
        this(logger, level, (java.util.function.LongPredicate)LOG_ALL_DURATIONS);
    }

    @Deprecated
    public LoggingInvocationEventHandler(Logger logger, LoggingLevel level, LongPredicate durationPredicate) {
        this(logger, level, (java.util.function.LongPredicate)durationPredicate);
    }

    public LoggingInvocationEventHandler(Logger logger, LoggingLevel level, java.util.function.LongPredicate durationPredicate) {
        super((java.util.function.BooleanSupplier)LoggingInvocationEventHandler.createEnabledSupplier(logger, level));
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger, (String)"logger");
        this.level = (LoggingLevel)((Object)Preconditions.checkNotNull((Object)((Object)level), (String)"level"));
        this.durationPredicate = (java.util.function.LongPredicate)Preconditions.checkNotNull((Object)durationPredicate, (String)"durationPredicate");
    }

    public final InvocationContext preInvocation(@Nonnull Object instance, @Nonnull Method method, @Nonnull Object[] args) {
        return DefaultInvocationContext.of((Object)instance, (Method)method, (Object[])args);
    }

    public final void onSuccess(@Nullable InvocationContext context, @Nullable Object result) {
        this.logInvocation(context);
    }

    public final void onFailure(@Nullable InvocationContext context, @Nonnull Throwable cause) {
        this.logInvocation(context);
    }

    private void logInvocation(@Nullable InvocationContext context) {
        this.debugIfNullContext(context);
        if (context != null) {
            long durationNanos = System.nanoTime() - context.getStartTimeNanos();
            this.logInvocation(context.getMethod(), context.getArgs(), durationNanos);
        }
    }

    private void logInvocation(Method method, @Nullable Object[] nullableArgs, long durationNanos) {
        if (this.isEnabled() && this.durationPredicate.test(durationNanos)) {
            Object[] args = LoggingInvocationEventHandler.nullToEmpty((Object[])nullableArgs);
            this.log(LoggingInvocationEventHandler.getMessagePattern(args), LoggingInvocationEventHandler.getLogParams(method, args, durationNanos, this.level));
        }
    }

    private void log(String messageFormat, Object[] args) {
        if (this.level == LoggingLevel.TRACE) {
            this.logger.trace(messageFormat, args);
        } else if (this.level == LoggingLevel.DEBUG) {
            this.logger.debug(messageFormat, args);
        } else {
            this.logUncommon(messageFormat, args);
        }
    }

    private void logUncommon(String messageFormat, Object[] args) {
        if (this.level == LoggingLevel.INFO) {
            this.logger.info(messageFormat, args);
        } else if (this.level == LoggingLevel.WARN) {
            this.logger.warn(messageFormat, args);
        } else if (this.level == LoggingLevel.ERROR) {
            this.logger.error(messageFormat, args);
        } else {
            throw LoggingInvocationEventHandler.invalidLoggingLevel(this.level);
        }
    }

    static boolean isEnabled(Logger logger, LoggingLevel level) {
        if (level == LoggingLevel.TRACE) {
            return logger.isTraceEnabled();
        }
        if (level == LoggingLevel.DEBUG) {
            return logger.isDebugEnabled();
        }
        return LoggingInvocationEventHandler.isEnabledUncommon(logger, level);
    }

    private static boolean isEnabledUncommon(Logger logger, LoggingLevel level) {
        if (level == LoggingLevel.INFO) {
            return logger.isInfoEnabled();
        }
        if (level == LoggingLevel.WARN) {
            return logger.isWarnEnabled();
        }
        if (level == LoggingLevel.ERROR) {
            return logger.isErrorEnabled();
        }
        throw LoggingInvocationEventHandler.invalidLoggingLevel(level);
    }

    private static IllegalArgumentException invalidLoggingLevel(LoggingLevel level) {
        Preconditions.checkNotNull((Object)((Object)level), (String)"level");
        return new IllegalArgumentException("Unsupported logging level " + (Object)((Object)level));
    }

    private static BooleanSupplier createEnabledSupplier(Logger logger, LoggingLevel level) {
        Preconditions.checkNotNull((Object)logger, (String)"logger");
        Preconditions.checkNotNull((Object)((Object)level), (String)"level");
        if (LoggingInvocationEventHandler.getSystemPropertySupplier(LoggingInvocationEventHandler.class).getAsBoolean()) {
            return () -> LoggingInvocationEventHandler.isEnabled(logger, level);
        }
        return BooleanSupplier.FALSE;
    }

    private static List<String> generateMessagePatterns(int maxArgCount) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i <= maxArgCount; ++i) {
            builder.add((Object)LoggingInvocationEventHandler.generateMessagePattern(i));
        }
        return builder.build();
    }

    static String generateMessagePattern(int argCount) {
        int estimatedSize = 17 + Math.max(0, argCount * 4 - 2);
        StringBuilder message = new StringBuilder(estimatedSize);
        message.append("{}.{}(");
        for (int i = 0; i < argCount; ++i) {
            if (i > 0) {
                message.append(", ");
            }
            message.append("{}");
        }
        message.append(") took {}ms");
        return message.toString();
    }

    static String getMessagePattern(Object[] args) {
        if (args.length < MESSAGE_PATTERNS.size()) {
            return MESSAGE_PATTERNS.get(args.length);
        }
        return LoggingInvocationEventHandler.generateMessagePattern(args.length);
    }

    static Object[] getLogParams(Method method, Object[] args, long durationNanos, LoggingLevel level) {
        Object[] logParams = new Arg[3 + args.length];
        logParams[0] = SafeArg.of((String)"class", (Object)method.getDeclaringClass().getSimpleName());
        logParams[1] = SafeArg.of((String)"method", (Object)method.getName());
        logParams[logParams.length - 1] = SafeArg.of((String)"milliseconds", (Object)String.format("%.3f", (double)durationNanos / 1000000.0));
        Class<?>[] argTypes = method.getParameterTypes();
        if (argTypes.length == 0) {
            return logParams;
        }
        for (int i = 0; i < argTypes.length; ++i) {
            Object arg;
            String argMessage = argTypes[i].getSimpleName();
            if (level == LoggingLevel.TRACE && i < args.length && (arg = args[i]) instanceof Collection) {
                argMessage = argMessage + "[" + ((Collection)arg).size() + "]";
            }
            logParams[2 + i] = SafeArg.of((String)("type" + i), (Object)argMessage);
        }
        return logParams;
    }
}

