/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import com.palominolabs.metrics.guice.ExceptionMeteredListener;
import com.palominolabs.metrics.guice.GaugeListener;
import com.palominolabs.metrics.guice.JmxReporterProvider;
import com.palominolabs.metrics.guice.MeteredListener;
import com.palominolabs.metrics.guice.TimedListener;
import com.yammer.metrics.HealthChecks;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.HealthCheckRegistry;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.reporting.JmxReporter;

public class InstrumentationModule
extends AbstractModule {
    protected void configure() {
        MetricsRegistry metricsRegistry = this.createMetricsRegistry();
        this.bind(MetricsRegistry.class).toInstance((Object)metricsRegistry);
        this.bind(HealthCheckRegistry.class).toInstance((Object)this.createHealthCheckRegistry());
        this.bindJmxReporter();
        this.bindListener(Matchers.any(), new MeteredListener(metricsRegistry));
        this.bindListener(Matchers.any(), new TimedListener(metricsRegistry));
        this.bindListener(Matchers.any(), new GaugeListener(metricsRegistry));
        this.bindListener(Matchers.any(), new ExceptionMeteredListener(metricsRegistry));
    }

    protected void bindJmxReporter() {
        this.bind(JmxReporter.class).toProvider(JmxReporterProvider.class).in(Scopes.SINGLETON);
    }

    protected HealthCheckRegistry createHealthCheckRegistry() {
        return HealthChecks.defaultRegistry();
    }

    protected MetricsRegistry createMetricsRegistry() {
        return Metrics.defaultRegistry();
    }
}

