/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.yammer.metrics.annotation.Metered;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class MeteredInterceptor
implements MethodInterceptor {
    private final Meter meter;

    static MethodInterceptor forMethod(MetricsRegistry metricsRegistry, Class<?> klass, Method method) {
        Metered annotation = method.getAnnotation(Metered.class);
        if (annotation != null) {
            String group = MetricName.chooseGroup((String)annotation.group(), klass);
            String type = MetricName.chooseType((String)annotation.type(), klass);
            String name = MetricName.chooseName((String)annotation.name(), (Method)method);
            MetricName metricName = new MetricName(group, type, name);
            Meter meter = metricsRegistry.newMeter(metricName, annotation.eventType(), annotation.rateUnit());
            return new MeteredInterceptor(meter);
        }
        return null;
    }

    private MeteredInterceptor(Meter meter) {
        this.meter = meter;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.meter.mark();
        return invocation.proceed();
    }
}

