/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.palominolabs.metrics.guice.MeteredInterceptor;
import com.yammer.metrics.core.MetricsRegistry;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;

class MeteredListener
implements TypeListener {
    private final MetricsRegistry metricsRegistry;

    MeteredListener(MetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
    }

    public <T> void hear(TypeLiteral<T> literal, TypeEncounter<T> encounter) {
        Class klass = literal.getRawType();
        do {
            for (Method method : klass.getDeclaredMethods()) {
                MethodInterceptor interceptor = MeteredInterceptor.forMethod(this.metricsRegistry, klass, method);
                if (interceptor == null) continue;
                encounter.bindInterceptor(Matchers.only((Object)method), new MethodInterceptor[]{interceptor});
            }
        } while ((klass = klass.getSuperclass()) != null);
    }
}

