/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice.servlet;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.core.HealthCheckRegistry;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.reporting.AdminServlet;
import com.yammer.metrics.reporting.HealthCheckServlet;
import com.yammer.metrics.reporting.MetricsServlet;
import com.yammer.metrics.reporting.PingServlet;
import com.yammer.metrics.reporting.ThreadDumpServlet;
import java.util.Set;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;

public class AdminServletProvider
implements Provider<AdminServlet> {
    private final MetricsRegistry metricsRegistry;
    private final HealthCheckRegistry healthCheckRegistry;
    private final Set<HealthCheck> healthChecks;
    private final String healthcheckUri;
    private final String metricsUri;
    private final String pingUri;
    private final String threadsUri;
    private JsonFactory jsonFactory;

    @Inject
    public AdminServletProvider(Set<HealthCheck> healthChecks, MetricsRegistry metricsRegistry, HealthCheckRegistry healthCheckRegistry, @Named(value="AdminServlet.HEALTHCHECK_URI") String healthcheckUri, @Named(value="AdminServlet.METRICS_URI") String metricsUri, @Named(value="AdminServlet.PING_URI") String pingUri, @Named(value="AdminServlet.THREADS_URI") String threadsUri) {
        this.metricsRegistry = metricsRegistry;
        this.healthCheckRegistry = healthCheckRegistry;
        this.healthcheckUri = healthcheckUri;
        this.metricsUri = metricsUri;
        this.pingUri = pingUri;
        this.threadsUri = threadsUri;
        this.healthChecks = healthChecks;
    }

    @Inject(optional=true)
    public void setJsonFactory(@Named(value="AdminServlet.JSON_FACTORY") JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public AdminServlet get() {
        for (HealthCheck healthCheck : this.healthChecks) {
            this.healthCheckRegistry.register(healthCheck);
        }
        JsonFactory factory = this.jsonFactory == null ? new JsonFactory((ObjectCodec)new ObjectMapper()) : this.jsonFactory;
        return new AdminServlet(new HealthCheckServlet(this.healthCheckRegistry), new MetricsServlet(Clock.defaultClock(), VirtualMachineMetrics.getInstance(), this.metricsRegistry, factory, true), new PingServlet(), new ThreadDumpServlet(VirtualMachineMetrics.getInstance()), this.healthcheckUri, this.metricsUri, this.pingUri, this.threadsUri);
    }
}

