/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.ExceptionMetered;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class ExceptionMeteredInterceptor
implements MethodInterceptor {
    private final Meter meter;
    private final Class<? extends Throwable> klass;

    static MethodInterceptor forMethod(MetricRegistry metricRegistry, Class<?> klass, Method method) {
        ExceptionMetered annotation = method.getAnnotation(ExceptionMetered.class);
        if (annotation != null) {
            Meter meter = metricRegistry.meter(ExceptionMeteredInterceptor.determineName(annotation, klass, method));
            return new ExceptionMeteredInterceptor(meter, annotation.cause());
        }
        return null;
    }

    private static String determineName(ExceptionMetered annotation, Class<?> klass, Method method) {
        if (annotation.absolute()) {
            return annotation.name();
        }
        if (annotation.name().isEmpty()) {
            return MetricRegistry.name(klass, (String[])new String[]{method.getName(), "exceptions"});
        }
        return MetricRegistry.name(klass, (String[])new String[]{annotation.name()});
    }

    private ExceptionMeteredInterceptor(Meter meter, Class<? extends Throwable> klass) {
        this.meter = meter;
        this.klass = klass;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            if (this.klass.isAssignableFrom(t.getClass())) {
                this.meter.mark();
            }
            throw t;
        }
    }
}

