/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Gauge;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.palominolabs.metrics.guice.GaugeInjectionListener;
import java.lang.reflect.Method;

public class GaugeListener
implements TypeListener {
    private final MetricRegistry metricRegistry;

    public GaugeListener(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public <I> void hear(TypeLiteral<I> literal, TypeEncounter<I> encounter) {
        Class klass = literal.getRawType();
        for (Method method : klass.getMethods()) {
            Gauge annotation = method.getAnnotation(Gauge.class);
            if (annotation == null) continue;
            if (method.getParameterTypes().length == 0) {
                String metricName = GaugeListener.determineName(annotation, klass, method);
                encounter.register(new GaugeInjectionListener(this.metricRegistry, metricName, method));
                continue;
            }
            encounter.addError("Method %s is annotated with @Gauge but requires parameters.", new Object[]{method});
        }
    }

    private static String determineName(Gauge annotation, Class<?> klass, Method method) {
        if (annotation.absolute()) {
            return annotation.name();
        }
        if (annotation.name().isEmpty()) {
            return MetricRegistry.name(klass, (String[])new String[]{method.getName(), Gauge.class.getSimpleName()});
        }
        return MetricRegistry.name(klass, (String[])new String[]{annotation.name()});
    }
}

