/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class TimedInterceptor
implements MethodInterceptor {
    private final Timer timer;

    static MethodInterceptor forMethod(MetricRegistry metricRegistry, Class<?> klass, Method method) {
        Timed annotation = method.getAnnotation(Timed.class);
        if (annotation != null) {
            Timer timer = metricRegistry.timer(TimedInterceptor.determineName(annotation, klass, method));
            return new TimedInterceptor(timer);
        }
        return null;
    }

    private static String determineName(Timed annotation, Class<?> klass, Method method) {
        if (annotation.absolute()) {
            return annotation.name();
        }
        if (annotation.name().isEmpty()) {
            return MetricRegistry.name(klass, (String[])new String[]{method.getName(), Timed.class.getSimpleName()});
        }
        return MetricRegistry.name(klass, (String[])new String[]{annotation.name()});
    }

    private TimedInterceptor(Timer timer) {
        this.timer = timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Timer.Context ctx = this.timer.time();
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            ctx.stop();
        }
    }
}

