/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.Counter;
import com.codahale.metrics.annotation.Counted;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class CountedInterceptor
implements MethodInterceptor {
    private final Counter counter;
    private final Counted annotation;

    CountedInterceptor(Counter counter, Counted annotation) {
        this.counter = counter;
        this.annotation = annotation;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.counter.inc();
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (!this.annotation.monotonic()) {
                this.counter.dec();
            }
        }
    }
}

