/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Counted;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.palominolabs.metrics.guice.CountedInterceptor;
import com.palominolabs.metrics.guice.MetricNamer;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;

public class CountedListener
implements TypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;

    CountedListener(MetricRegistry metricRegistry, MetricNamer metricNamer) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
    }

    public <T> void hear(TypeLiteral<T> literal, TypeEncounter<T> encounter) {
        Class klass = literal.getRawType();
        do {
            for (Method method : klass.getDeclaredMethods()) {
                MethodInterceptor interceptor = this.getInterceptor(this.metricRegistry, method);
                if (interceptor == null) continue;
                encounter.bindInterceptor(Matchers.only((Object)method), new MethodInterceptor[]{interceptor});
            }
        } while ((klass = klass.getSuperclass()) != null);
    }

    @Nullable
    private MethodInterceptor getInterceptor(MetricRegistry metricRegistry, Method method) {
        Counted annotation = method.getAnnotation(Counted.class);
        if (annotation != null) {
            Counter counter = metricRegistry.counter(this.metricNamer.getNameForCounted(method, annotation));
            return new CountedInterceptor(counter, annotation);
        }
        return null;
    }
}

