/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.palominolabs.metrics.guice.ExceptionMeteredInterceptor;
import com.palominolabs.metrics.guice.MetricNamer;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;

public class ExceptionMeteredListener
implements TypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;

    public ExceptionMeteredListener(MetricRegistry metricRegistry, MetricNamer metricNamer) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
    }

    public <T> void hear(TypeLiteral<T> literal, TypeEncounter<T> encounter) {
        Class klass = literal.getRawType();
        for (Method method : klass.getDeclaredMethods()) {
            MethodInterceptor interceptor = this.getInterceptor(this.metricRegistry, method);
            if (interceptor == null) continue;
            encounter.bindInterceptor(Matchers.only((Object)method), new MethodInterceptor[]{interceptor});
        }
    }

    @Nullable
    private MethodInterceptor getInterceptor(MetricRegistry metricRegistry, Method method) {
        ExceptionMetered annotation = method.getAnnotation(ExceptionMetered.class);
        if (annotation != null) {
            Meter meter = metricRegistry.meter(this.metricNamer.getNameForExceptionMetered(method, annotation));
            return new ExceptionMeteredInterceptor(meter, annotation.cause());
        }
        return null;
    }
}

