/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Gauge;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.palominolabs.metrics.guice.GaugeInjectionListener;
import com.palominolabs.metrics.guice.MetricNamer;
import java.lang.reflect.Method;

public class GaugeListener
implements TypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;

    public GaugeListener(MetricRegistry metricRegistry, MetricNamer metricNamer) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
    }

    public <I> void hear(TypeLiteral<I> literal, TypeEncounter<I> encounter) {
        Class klass = literal.getRawType();
        for (Method method : klass.getMethods()) {
            Gauge annotation = method.getAnnotation(Gauge.class);
            if (annotation == null) continue;
            if (method.getParameterTypes().length == 0) {
                String metricName = this.metricNamer.getNameForGauge(method, annotation);
                encounter.register(new GaugeInjectionListener(this.metricRegistry, metricName, method));
                continue;
            }
            encounter.addError("Method %s is annotated with @Gauge but requires parameters.", new Object[]{method});
        }
    }
}

