/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.palominolabs.metrics.guice.MetricNamer;
import com.palominolabs.metrics.guice.TimedInterceptor;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;

public class TimedListener
implements TypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;

    public TimedListener(MetricRegistry metricRegistry, MetricNamer metricNamer) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
    }

    public <T> void hear(TypeLiteral<T> literal, TypeEncounter<T> encounter) {
        Class klass = literal.getRawType();
        do {
            for (Method method : klass.getDeclaredMethods()) {
                MethodInterceptor interceptor = this.getInterceptor(this.metricRegistry, method);
                if (interceptor == null) continue;
                encounter.bindInterceptor(Matchers.only((Object)method), new MethodInterceptor[]{interceptor});
            }
        } while ((klass = klass.getSuperclass()) != null);
    }

    @Nullable
    private MethodInterceptor getInterceptor(MetricRegistry metricRegistry, Method method) {
        Timed annotation = method.getAnnotation(Timed.class);
        if (annotation != null) {
            Timer timer = metricRegistry.timer(this.metricNamer.getNameForTimed(method, annotation));
            return new TimedInterceptor(timer);
        }
        return null;
    }
}

