/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.annotation.Counted;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class CountedInterceptor
implements MethodInterceptor {
    private final Counter counter;
    private final boolean decrementAfterMethod;

    CountedInterceptor(Counter counter, Counted annotation) {
        this.counter = counter;
        this.decrementAfterMethod = !annotation.monotonic();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.counter.inc();
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (this.decrementAfterMethod) {
                this.counter.dec();
            }
        }
    }
}

