/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.palominolabs.metrics.guice.MetricNamer;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.annotation.Counted;
import io.dropwizard.metrics5.annotation.ExceptionMetered;
import io.dropwizard.metrics5.annotation.Gauge;
import io.dropwizard.metrics5.annotation.Metered;
import io.dropwizard.metrics5.annotation.Timed;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;

public class DeclaringClassMetricNamer
implements MetricNamer {
    static final String COUNTER_SUFFIX = "counter";
    static final String COUNTER_SUFFIX_MONOTONIC = "current";
    static final String GAUGE_SUFFIX = "gauge";
    static final String METERED_SUFFIX = "meter";
    static final String TIMED_SUFFIX = "timer";

    @Override
    @Nonnull
    public MetricName getNameForCounted(@Nonnull Method method, @Nonnull Counted counted) {
        if (counted.absolute()) {
            return MetricRegistry.name((String)counted.name(), (String[])new String[0]);
        }
        if (counted.name().isEmpty()) {
            if (counted.monotonic()) {
                return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), COUNTER_SUFFIX_MONOTONIC});
            }
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), COUNTER_SUFFIX});
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{counted.name()});
    }

    @Override
    @Nonnull
    public MetricName getNameForExceptionMetered(@Nonnull Method method, @Nonnull ExceptionMetered exceptionMetered) {
        if (exceptionMetered.absolute()) {
            return MetricRegistry.name((String)exceptionMetered.name(), (String[])new String[0]);
        }
        if (exceptionMetered.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), "exceptions"});
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{exceptionMetered.name()});
    }

    @Override
    @Nonnull
    public MetricName getNameForGauge(@Nonnull Class<?> instanceClass, @Nonnull Method method, @Nonnull Gauge gauge) {
        if (gauge.absolute()) {
            return MetricRegistry.name((String)gauge.name(), (String[])new String[0]);
        }
        if (gauge.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), GAUGE_SUFFIX});
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{gauge.name()});
    }

    @Override
    @Nonnull
    public MetricName getNameForMetered(@Nonnull Method method, @Nonnull Metered metered) {
        if (metered.absolute()) {
            return MetricRegistry.name((String)metered.name(), (String[])new String[0]);
        }
        if (metered.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), METERED_SUFFIX});
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{metered.name()});
    }

    @Override
    @Nonnull
    public MetricName getNameForTimed(@Nonnull Method method, @Nonnull Timed timed) {
        if (timed.absolute()) {
            return MetricRegistry.name((String)timed.name(), (String[])new String[0]);
        }
        if (timed.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName(), TIMED_SUFFIX});
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{timed.name()});
    }
}

