/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.palominolabs.metrics.guice.DeclaredMethodsTypeListener;
import com.palominolabs.metrics.guice.ExceptionMeteredInterceptor;
import com.palominolabs.metrics.guice.MetricNamer;
import com.palominolabs.metrics.guice.annotation.AnnotationResolver;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.annotation.ExceptionMetered;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;

public class ExceptionMeteredListener
extends DeclaredMethodsTypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;

    public ExceptionMeteredListener(MetricRegistry metricRegistry, MetricNamer metricNamer, AnnotationResolver annotationResolver) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
        this.annotationResolver = annotationResolver;
    }

    @Override
    @Nullable
    protected MethodInterceptor getInterceptor(Method method) {
        ExceptionMetered annotation = this.annotationResolver.findAnnotation(ExceptionMetered.class, method);
        if (annotation != null) {
            Meter meter = this.metricRegistry.meter(this.metricNamer.getNameForExceptionMetered(method, annotation));
            return new ExceptionMeteredInterceptor(meter, annotation.cause());
        }
        return null;
    }
}

