/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.google.inject.spi.InjectionListener;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import java.lang.reflect.Method;

public class GaugeInjectionListener<I>
implements InjectionListener<I> {
    private final MetricRegistry metricRegistry;
    private final MetricName metricName;
    private final Method method;

    public GaugeInjectionListener(MetricRegistry metricRegistry, MetricName metricName, Method method) {
        this.metricRegistry = metricRegistry;
        this.metricName = metricName;
        this.method = method;
    }

    public void afterInjection(I i) {
        this.metricRegistry.register(this.metricName, (Metric)((Gauge)() -> {
            try {
                return this.method.invoke(i, new Object[0]);
            }
            catch (Exception e) {
                return new RuntimeException(e);
            }
        }));
    }
}

