/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.palominolabs.metrics.guice.GaugeInjectionListener;
import com.palominolabs.metrics.guice.MetricNamer;
import com.palominolabs.metrics.guice.annotation.AnnotationResolver;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.annotation.Gauge;
import java.lang.reflect.Method;

public class GaugeListener
implements TypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;

    public GaugeListener(MetricRegistry metricRegistry, MetricNamer metricNamer, AnnotationResolver annotationResolver) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
        this.annotationResolver = annotationResolver;
    }

    public <I> void hear(TypeLiteral<I> literal, TypeEncounter<I> encounter) {
        Class klass;
        Class instanceType = klass = literal.getRawType();
        do {
            for (Method method : klass.getDeclaredMethods()) {
                Gauge annotation;
                if (method.isSynthetic() || (annotation = this.annotationResolver.findAnnotation(Gauge.class, method)) == null) continue;
                if (method.getParameterTypes().length == 0) {
                    MetricName metricName = this.metricNamer.getNameForGauge(instanceType, method, annotation);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    encounter.register(new GaugeInjectionListener(this.metricRegistry, metricName, method));
                    continue;
                }
                encounter.addError("Method %s is annotated with @Gauge but requires parameters.", new Object[]{method});
            }
        } while ((klass = klass.getSuperclass()) != null);
    }
}

