/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.palominolabs.metrics.guice.CountedListener;
import com.palominolabs.metrics.guice.ExceptionMeteredListener;
import com.palominolabs.metrics.guice.GaugeInstanceClassMetricNamer;
import com.palominolabs.metrics.guice.GaugeListener;
import com.palominolabs.metrics.guice.MeteredListener;
import com.palominolabs.metrics.guice.MetricNamer;
import com.palominolabs.metrics.guice.TimedListener;
import com.palominolabs.metrics.guice.annotation.AnnotationResolver;
import com.palominolabs.metrics.guice.annotation.MethodAnnotationResolver;
import io.dropwizard.metrics5.MetricRegistry;
import javax.annotation.Nonnull;

public class MetricsInstrumentationModule
extends AbstractModule {
    private final MetricRegistry metricRegistry;
    private final Matcher<? super TypeLiteral<?>> matcher;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;

    public static Builder builder() {
        return new Builder();
    }

    private MetricsInstrumentationModule(MetricRegistry metricRegistry, Matcher<? super TypeLiteral<?>> matcher, MetricNamer metricNamer, AnnotationResolver annotationResolver) {
        this.metricRegistry = metricRegistry;
        this.matcher = matcher;
        this.metricNamer = metricNamer;
        this.annotationResolver = annotationResolver;
    }

    protected void configure() {
        this.bindListener(this.matcher, new MeteredListener(this.metricRegistry, this.metricNamer, this.annotationResolver));
        this.bindListener(this.matcher, new TimedListener(this.metricRegistry, this.metricNamer, this.annotationResolver));
        this.bindListener(this.matcher, new GaugeListener(this.metricRegistry, this.metricNamer, this.annotationResolver));
        this.bindListener(this.matcher, new ExceptionMeteredListener(this.metricRegistry, this.metricNamer, this.annotationResolver));
        this.bindListener(this.matcher, new CountedListener(this.metricRegistry, this.metricNamer, this.annotationResolver));
    }

    public static class Builder {
        private MetricRegistry metricRegistry;
        private Matcher<? super TypeLiteral<?>> matcher = Matchers.any();
        private MetricNamer metricNamer = new GaugeInstanceClassMetricNamer();
        private AnnotationResolver annotationResolver = new MethodAnnotationResolver();

        @Nonnull
        public Builder withMetricRegistry(@Nonnull MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }

        @Nonnull
        public Builder withMatcher(@Nonnull Matcher<? super TypeLiteral<?>> matcher) {
            this.matcher = matcher;
            return this;
        }

        @Nonnull
        public Builder withMetricNamer(@Nonnull MetricNamer metricNamer) {
            this.metricNamer = metricNamer;
            return this;
        }

        @Nonnull
        public Builder withAnnotationMatcher(@Nonnull AnnotationResolver annotationResolver) {
            this.annotationResolver = annotationResolver;
            return this;
        }

        @Nonnull
        public MetricsInstrumentationModule build() {
            return new MetricsInstrumentationModule((MetricRegistry)Preconditions.checkNotNull((Object)this.metricRegistry), (Matcher)Preconditions.checkNotNull(this.matcher), (MetricNamer)Preconditions.checkNotNull((Object)this.metricNamer), (AnnotationResolver)Preconditions.checkNotNull((Object)this.annotationResolver));
        }
    }
}

