/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.palominolabs.metrics.guice.DeclaredMethodsTypeListener;
import com.palominolabs.metrics.guice.MetricNamer;
import com.palominolabs.metrics.guice.TimedInterceptor;
import com.palominolabs.metrics.guice.annotation.AnnotationResolver;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import io.dropwizard.metrics5.annotation.Timed;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;

public class TimedListener
extends DeclaredMethodsTypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;

    public TimedListener(MetricRegistry metricRegistry, MetricNamer metricNamer, AnnotationResolver annotationResolver) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
        this.annotationResolver = annotationResolver;
    }

    @Override
    @Nullable
    protected MethodInterceptor getInterceptor(Method method) {
        Timed annotation = this.annotationResolver.findAnnotation(Timed.class, method);
        if (annotation != null) {
            Timer timer = this.metricRegistry.timer(this.metricNamer.getNameForTimed(method, annotation));
            return new TimedInterceptor(timer);
        }
        return null;
    }
}

