/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.newrelic;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.newrelic.api.agent.NewRelic;
import com.palominolabs.metrics.newrelic.MetricAttributeFilter;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class NewRelicReporter
extends ScheduledReporter {
    private final MetricAttributeFilter attributeFilter;
    private final String metricNamePrefix;

    public NewRelicReporter(MetricRegistry registry, String name, MetricFilter filter, MetricAttributeFilter attributeFilter, TimeUnit rateUnit, TimeUnit durationUnit, String metricNamePrefix) {
        super(registry, name, filter, rateUnit, durationUnit);
        this.attributeFilter = attributeFilter;
        this.metricNamePrefix = metricNamePrefix;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        String name;
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.doGauge(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            Counter counter;
            name = entry.getKey();
            if (!this.attributeFilter.recordCounterCount(name, counter = (Counter)entry.getValue())) continue;
            this.record(name + "/count", counter.getCount());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            name = entry.getKey();
            Snapshot snapshot = ((Histogram)entry.getValue()).getSnapshot();
            Histogram metric = (Histogram)entry.getValue();
            this.doHistogramSnapshot(name, snapshot, metric);
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            name = entry.getKey();
            Meter meter = (Meter)entry.getValue();
            this.doMetered(name, meter);
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            Timer timer = (Timer)entry.getValue();
            String name2 = entry.getKey();
            Snapshot snapshot = timer.getSnapshot();
            this.doTimerMetered(timer, name2);
            this.doTimerSnapshot(timer, name2, snapshot);
        }
    }

    private void doMetered(String name, Meter meter) {
        if (this.attributeFilter.recordMeterCount(name, meter)) {
            this.record(name + "/count", meter.getCount());
        }
        if (this.attributeFilter.recordMeterMeanRate(name, meter)) {
            this.record(name + "/meanRate/" + this.getRateUnit(), (float)this.convertRate(meter.getMeanRate()));
        }
        if (this.attributeFilter.recordMeter1MinuteRate(name, meter)) {
            this.record(name + "/1MinuteRate/" + this.getRateUnit(), (float)this.convertRate(meter.getOneMinuteRate()));
        }
        if (this.attributeFilter.recordMeter5MinuteRate(name, meter)) {
            this.record(name + "/5MinuteRate/" + this.getRateUnit(), (float)this.convertRate(meter.getFiveMinuteRate()));
        }
        if (this.attributeFilter.recordMeter15MinuteRate(name, meter)) {
            this.record(name + "/15MinuteRate/" + this.getRateUnit(), (float)this.convertRate(meter.getFifteenMinuteRate()));
        }
    }

    private void doTimerMetered(Timer timer, String name) {
        if (this.attributeFilter.recordTimerCount(name, timer)) {
            this.record(name + "/count", timer.getCount());
        }
        if (this.attributeFilter.recordTimerMeanRate(name, timer)) {
            this.record(name + "/meanRate/" + this.getRateUnit(), (float)this.convertRate(timer.getMeanRate()));
        }
        if (this.attributeFilter.recordTimer1MinuteRate(name, timer)) {
            this.record(name + "/1MinuteRate/" + this.getRateUnit(), (float)this.convertRate(timer.getOneMinuteRate()));
        }
        if (this.attributeFilter.recordTimer5MinuteRate(name, timer)) {
            this.record(name + "/5MinuteRate/" + this.getRateUnit(), (float)this.convertRate(timer.getFiveMinuteRate()));
        }
        if (this.attributeFilter.recordTimer15MinuteRate(name, timer)) {
            this.record(name + "/15MinuteRate/" + this.getRateUnit(), (float)this.convertRate(timer.getFifteenMinuteRate()));
        }
    }

    private void doHistogramSnapshot(String name, Snapshot snapshot, Histogram metric) {
        if (this.attributeFilter.recordHistogramMin(name, metric)) {
            this.record(name + "/min", (float)this.convertDuration(snapshot.getMin()));
        }
        if (this.attributeFilter.recordHistogramMax(name, metric)) {
            this.record(name + "/max", (float)this.convertDuration(snapshot.getMax()));
        }
        if (this.attributeFilter.recordHistogramMean(name, metric)) {
            this.record(name + "/mean", (float)this.convertDuration(snapshot.getMean()));
        }
        if (this.attributeFilter.recordHistogramStdDev(name, metric)) {
            this.record(name + "/stdDev", (float)this.convertDuration(snapshot.getStdDev()));
        }
        if (this.attributeFilter.recordHistogramMedian(name, metric)) {
            this.record(name + "/median", (float)this.convertDuration(snapshot.getMedian()));
        }
        if (this.attributeFilter.recordHistogram75thPercentile(name, metric)) {
            this.record(name + "/75th", (float)this.convertDuration(snapshot.get75thPercentile()));
        }
        if (this.attributeFilter.recordHistogram95thPercentile(name, metric)) {
            this.record(name + "/95th", (float)this.convertDuration(snapshot.get95thPercentile()));
        }
        if (this.attributeFilter.recordHistogram98thPercentile(name, metric)) {
            this.record(name + "/98th", (float)this.convertDuration(snapshot.get98thPercentile()));
        }
        if (this.attributeFilter.recordHistogram99thPercentile(name, metric)) {
            this.record(name + "/99th", (float)this.convertDuration(snapshot.get99thPercentile()));
        }
        if (this.attributeFilter.recordHistogram999thPercentile(name, metric)) {
            this.record(name + "/99.9th", (float)this.convertDuration(snapshot.get999thPercentile()));
        }
    }

    private void doTimerSnapshot(Timer timer, String name, Snapshot snapshot) {
        String nameSuffix = "/" + this.getDurationUnit();
        if (this.attributeFilter.recordTimerMin(name, timer)) {
            this.record(name + "/min" + nameSuffix, (float)this.convertDuration(snapshot.getMin()));
        }
        if (this.attributeFilter.recordTimerMax(name, timer)) {
            this.record(name + "/max" + nameSuffix, (float)this.convertDuration(snapshot.getMax()));
        }
        if (this.attributeFilter.recordTimerMean(name, timer)) {
            this.record(name + "/mean" + nameSuffix, (float)this.convertDuration(snapshot.getMean()));
        }
        if (this.attributeFilter.recordTimerStdDev(name, timer)) {
            this.record(name + "/stdDev" + nameSuffix, (float)this.convertDuration(snapshot.getStdDev()));
        }
        if (this.attributeFilter.recordTimerMedian(name, timer)) {
            this.record(name + "/median" + nameSuffix, (float)this.convertDuration(snapshot.getMedian()));
        }
        if (this.attributeFilter.recordTimer75thPercentile(name, timer)) {
            this.record(name + "/75th" + nameSuffix, (float)this.convertDuration(snapshot.get75thPercentile()));
        }
        if (this.attributeFilter.recordTimer95thPercentile(name, timer)) {
            this.record(name + "/95th" + nameSuffix, (float)this.convertDuration(snapshot.get95thPercentile()));
        }
        if (this.attributeFilter.recordTimer98thPercentile(name, timer)) {
            this.record(name + "/98th" + nameSuffix, (float)this.convertDuration(snapshot.get98thPercentile()));
        }
        if (this.attributeFilter.recordTimer99thPercentile(name, timer)) {
            this.record(name + "/99th" + nameSuffix, (float)this.convertDuration(snapshot.get99thPercentile()));
        }
        if (this.attributeFilter.recordTimer999thPercentile(name, timer)) {
            this.record(name + "/99.9th" + nameSuffix, (float)this.convertDuration(snapshot.get999thPercentile()));
        }
    }

    private void doGauge(String name, Gauge gauge) {
        float n;
        Object gaugeValue = gauge.getValue();
        if (gaugeValue instanceof Number && !Float.isNaN(n = ((Number)gaugeValue).floatValue()) && !Float.isInfinite(n) && this.attributeFilter.recordGaugeValue(name, gauge)) {
            this.record(name, n);
        }
    }

    private void record(String name, float value) {
        NewRelic.recordMetric((String)("Custom/" + this.metricNamePrefix + name), (float)value);
    }
}

