/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.panayotis.xray;

import com.panayotis.hrgui.helpers.FrameResolver;
import com.panayotis.xray.plugin.PluginManager;
import com.panayotis.xray.plugin.XRayPlugin;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.Timer;

/**
 *
 * @author teras
 */
public class XRayForm extends javax.swing.JFrame {

    private XRayPlugin current;
    private boolean initialized = false;

    /**
     * Creates new form XRayForm
     */
    @SuppressWarnings("OverridableMethodCallInConstructor")
    public XRayForm() {
        super("XRay Application");
        initComponents();
        setMinimumSize(new Dimension(150, 300));
        setPreferredSize(new Dimension(300, 500));
        setSize(new Dimension(300, 500));
    }

    // Invoke later due to lazy initialization of plugins
    void preInit() {
        JToggleButton first = null;
        for (XRayPlugin plugin : PluginManager.plugins()) {
            String name = plugin.getPluginName();
            JToggleButton button = new JToggleButton(plugin.getPluginName());
            JComponent visual = plugin.getPluginVisuals();
            toolbar.add(button);
            buttongroup.add(button);
            viewarea.add(visual, name);
            button.addActionListener((ActionEvent e) -> {
                ((CardLayout) viewarea.getLayout()).show(viewarea, name);
                plugin.onFocus();
            });
            if (first == null) {
                current = plugin;
                first = button;
            }
        }
        if (first != null)
            first.setSelected(true);

        Timer t = new Timer(3000, e -> postInit());
        t.setRepeats(false);
        t.start();
    }

    synchronized void postInit() {
        if (initialized)
            return;
        initialized = true;
        if (current != null)
            current.onFocus();
        FrameResolver.position(this, true, true);
        setVisible(true);
    }

    /**
     * This method is called from within the constructor to postInit the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttongroup = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        toolbar = new javax.swing.JToolBar();
        viewarea = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        getContentPane().setLayout(new java.awt.BorderLayout(5, 0));

        jPanel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jPanel1.setLayout(new java.awt.BorderLayout());

        toolbar.setBackground(new java.awt.Color(204, 222, 241));
        toolbar.setFloatable(false);
        jPanel1.add(toolbar, java.awt.BorderLayout.NORTH);

        viewarea.setLayout(new java.awt.CardLayout());
        jPanel1.add(viewarea, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttongroup;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JToolBar toolbar;
    private javax.swing.JPanel viewarea;
    // End of variables declaration//GEN-END:variables

}
