/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.plugin.awt;

import com.panayotis.xray.plugin.awt.AWTModel;
import com.panayotis.xray.plugin.awt.Demodalizer;
import com.panayotis.xray.plugin.awt.impl.ColorPropertyManager;
import com.panayotis.xray.plugin.awt.impl.DimensionPropertyManager;
import com.panayotis.xray.plugin.awt.impl.IconPropertyManager;
import com.panayotis.xray.plugin.awt.impl.ImagePropertyManager;
import com.panayotis.xray.plugin.awt.impl.PointPropertyManager;
import com.panayotis.xray.plugin.awt.impl.RectanglePropertyManager;
import com.panayotis.xray.props.PropertyManagerFactory;
import com.panayotis.xray.tree.PropertyTreePlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.Timer;

public class AWTPlugin
extends PropertyTreePlugin<Component> {
    private final FlashComponent flash = new FlashComponent();
    private final JToggleButton flashButton;
    private final Demodalizer demodalizer = new Demodalizer(this);

    public AWTPlugin() {
        super(new AWTModel(), "AWT", new PropertyManagerFactory());
        PropertyManagerFactory factory = this.getFactory();
        factory.register(Dimension.class, (instance, name, setter, getter) -> new DimensionPropertyManager(instance, name, setter, getter));
        factory.register(Point.class, (instance, name, setter, getter) -> new PointPropertyManager(instance, name, setter, getter));
        factory.register(Rectangle.class, (instance, name, setter, getter) -> new RectanglePropertyManager(instance, name, setter, getter));
        factory.register(Image.class, (instance, name, setter, getter) -> new ImagePropertyManager(instance, name, setter, getter));
        factory.register(Icon.class, (instance, name, setter, getter) -> new IconPropertyManager(instance, name, setter, getter));
        factory.register(Color.class, (instance, name, setter, getter) -> new ColorPropertyManager(instance, name, setter, getter));
        this.flashButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/icons/flash.png")));
        this.flashButton.addActionListener(e -> this.flashComponent());
        this.flashButton.setFocusable(false);
        this.addToolbarButton(this.flashButton);
        if (Demodalizer.isValid()) {
            JToggleButton demodButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/icons/lock.png")));
            demodButton.addActionListener(e -> this.demodalizer.setEnabled(((JToggleButton)e.getSource()).isSelected()));
            demodButton.setFocusable(false);
            demodButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/icons/unlock.png")));
            this.addToolbarButton(demodButton);
        }
    }

    private void flashComponent() {
        Timer t;
        Point loc;
        this.flashButton.setEnabled(false);
        if (this.flash.running) {
            this.reenableFlashButtonLater();
            return;
        }
        Component selected = (Component)this.getSelectedItem();
        Window window = AWTPlugin.getWindow(selected);
        if (window == null) {
            this.reenableFlashButtonLater();
            return;
        }
        try {
            loc = selected.getLocationOnScreen();
        }
        catch (Exception ex) {
            this.reenableFlashButtonLater();
            return;
        }
        this.flash.running = true;
        this.flash.w = selected.getWidth();
        this.flash.h = selected.getHeight();
        if (window instanceof JFrame) {
            JFrame frame = (JFrame)window;
            this.flash.x = loc.x - frame.getContentPane().getLocationOnScreen().x;
            this.flash.y = loc.y - frame.getContentPane().getLocationOnScreen().y;
            Component oldPane = frame.getGlassPane();
            frame.setGlassPane(this.flash);
            t = new Timer(500, e -> {
                frame.setGlassPane(oldPane);
                this.reenableFlashButtonNow();
            });
        } else if (window instanceof JDialog) {
            JDialog dialog = (JDialog)window;
            this.flash.x = loc.x - dialog.getContentPane().getLocationOnScreen().x;
            this.flash.y = loc.y - dialog.getContentPane().getLocationOnScreen().y;
            Component oldPane = dialog.getGlassPane();
            dialog.setGlassPane(this.flash);
            t = new Timer(500, e -> {
                dialog.setGlassPane(oldPane);
                this.reenableFlashButtonNow();
            });
        } else {
            this.reenableFlashButtonLater();
            return;
        }
        this.flash.setVisible(true);
        t.setRepeats(false);
        t.start();
    }

    private void reenableFlashButtonLater() {
        Timer t = new Timer(100, e -> this.reenableFlashButtonNow());
        t.setRepeats(false);
        t.start();
    }

    private void reenableFlashButtonNow() {
        this.flashButton.setSelected(false);
        this.flashButton.setEnabled(true);
        this.flash.running = false;
    }

    static Window getWindow(Component c) {
        while (c != null && !(c instanceof Window)) {
            c = c.getParent();
        }
        return (Window)c;
    }

    private class FlashComponent
    extends JComponent {
        private final Color color = new Color(1.0f, 0.0f, 0.0f, 0.5f);
        int x;
        int y;
        int w;
        int h;
        boolean running;

        private FlashComponent() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.color);
            g.fillRect(this.x, this.y, this.w, this.h);
        }
    }
}

