/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.plugin.awt.impl;

import com.panayotis.xray.plugin.awt.impl.DoubleNumberPropertyVisuals;
import com.panayotis.xray.props.PropertyManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RectanglePropertyManager
extends PropertyManager<Rectangle> {
    private final DoubleNumberPropertyVisuals location;
    private final DoubleNumberPropertyVisuals size;
    private final JPanel visuals = new JPanel(new BorderLayout());
    private int x;
    private int y;
    private int width;
    private int height;

    public RectanglePropertyManager(Object instance, String name, Method setter, Method getter) {
        super(instance, name, setter, getter);
        this.location = new DoubleNumberPropertyVisuals();
        this.location.setEnabled(!this.isReadOnly());
        this.location.addListener((gx, gy) -> {
            this.x = gx.intValue();
            this.y = gy.intValue();
            this.setValue(new Rectangle(this.x, this.y, this.width, this.height));
        }, false);
        this.location.setLabelName("  Location");
        this.size = new DoubleNumberPropertyVisuals();
        this.size.setEnabled(!this.isReadOnly());
        this.size.addListener((gwidth, gheight) -> {
            this.width = gwidth.intValue();
            this.height = gheight.intValue();
            this.setValue(new Rectangle(this.x, this.y, this.width, this.height));
        }, false);
        this.size.setLabelName("  Size");
        JLabel nameL = new JLabel(name);
        nameL.setEnabled(!this.isReadOnly());
        this.visuals.add((Component)nameL, "North");
        JPanel spinners = new JPanel(new GridLayout(2, 1));
        spinners.add(this.location);
        spinners.add(this.size);
        this.visuals.add((Component)spinners, "Center");
    }

    @Override
    protected JComponent createView() {
        return this.visuals;
    }

    @Override
    public void updateView(Rectangle item) {
        if (item != null) {
            this.x = item.x;
            this.y = item.y;
            this.width = item.width;
            this.height = item.height;
            this.location.update(this.x, this.y);
            this.size.update(this.width, this.height);
        }
    }

    @Override
    public Rectangle defaultValue() {
        return new Rectangle(0, 0, 0, 0);
    }
}

