/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.plugin.io;

import bsh.Interpreter;
import com.panayotis.xray.plugin.Logger;
import com.panayotis.xray.plugin.XRayPlugin;
import com.panayotis.xray.plugin.io.JAutoCompleteTextField;
import com.panayotis.xray.plugin.io.LetterBasedKit;
import com.panayotis.xray.sys.RedirectPrintStream;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class IOPlugin
extends JPanel
implements XRayPlugin {
    private final Interpreter inter = new Interpreter();
    private final SimpleAttributeSet outStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet errorStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet evalInputStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet evalOutputStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet evalErrorStyle = new SimpleAttributeSet();
    private JToggleButton both;
    private JScrollPane bothS;
    private JTextPane bothT;
    private JButton clean;
    private JPanel commandP;
    private JToggleButton error;
    private JScrollPane errorS;
    private JTextPane errorT;
    private Box.Filler filler1;
    private JTextField input;
    private JLabel jLabel1;
    private JToolBar jToolBar1;
    private JScrollPane outS;
    private JTextPane outT;
    private JToggleButton output;
    private ButtonGroup outputErrorGroup;
    private JPanel viewport;

    public IOPlugin() {
        this.initComponents();
        StyleConstants.setForeground(this.outStyle, Color.black);
        StyleConstants.setForeground(this.errorStyle, Color.red);
        StyleConstants.setItalic(this.evalInputStyle, true);
        StyleConstants.setForeground(this.evalInputStyle, Color.lightGray);
        StyleConstants.setForeground(this.evalOutputStyle, Color.blue);
        StyleConstants.setForeground(this.evalErrorStyle, Color.magenta);
        System.setOut(new RedirectPrintStream((OutputStream)System.out, t -> this.showOut((String)t, this.outStyle)));
        System.setErr(new RedirectPrintStream((OutputStream)System.out, t -> this.showError((String)t, this.errorStyle)));
        this.outT.setEditorKit(new LetterBasedKit());
        this.errorT.setEditorKit(new LetterBasedKit());
        this.bothT.setEditorKit(new LetterBasedKit());
        this.eval("import crossmobile.ios.uikit.*; import crossmobile.ios.coregraphics.*;", true);
        this.viewportUpdate();
    }

    @Override
    public String getPluginName() {
        return "I/O";
    }

    @Override
    public JComponent getPluginVisuals() {
        return this;
    }

    @Override
    public int getPluginOrder() {
        return 1000;
    }

    @Override
    public void onFocus() {
        this.input.requestFocusInWindow();
    }

    private void eval(String code, boolean silently) {
        if (code.trim().isEmpty()) {
            return;
        }
        if (!silently) {
            this.showOut("# " + code + "\n", this.evalInputStyle);
        }
        try {
            Object result = this.inter.eval(code);
            if (!silently) {
                this.showOut(result == null ? " - no result -\n" : result.toString().trim() + "\n", this.evalOutputStyle);
            }
        }
        catch (Throwable th) {
            this.showError(th.toString().trim() + "\n", this.evalErrorStyle);
        }
    }

    private void viewportUpdate() {
        if (this.outS.getParent() != null) {
            this.outS.getParent().remove(this.outS);
        }
        if (this.errorS.getParent() != null) {
            this.errorS.getParent().remove(this.errorS);
        }
        if (this.bothS.getParent() != null) {
            this.bothS.getParent().remove(this.bothS);
        }
        JScrollPane v = this.output.isSelected() ? this.outS : (this.error.isSelected() ? this.errorS : this.bothS);
        this.viewport.add((Component)v, "Center");
        this.viewport.revalidate();
        this.viewport.repaint();
    }

    private void showOut(String txt, SimpleAttributeSet style) {
        try {
            this.outT.getStyledDocument().insertString(this.outT.getStyledDocument().getLength(), txt, style);
            this.bothT.getStyledDocument().insertString(this.bothT.getStyledDocument().getLength(), txt, style);
            this.outT.setCaretPosition(this.outT.getDocument().getLength());
            this.bothT.setCaretPosition(this.bothT.getDocument().getLength());
            Logger.out(txt);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    private void showError(String txt, SimpleAttributeSet style) {
        try {
            this.errorT.getStyledDocument().insertString(this.errorT.getStyledDocument().getLength(), txt, style);
            this.bothT.getStyledDocument().insertString(this.bothT.getStyledDocument().getLength(), txt, style);
            this.errorT.setCaretPosition(this.errorT.getDocument().getLength());
            this.bothT.setCaretPosition(this.bothT.getDocument().getLength());
            Logger.err(txt);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.outputErrorGroup = new ButtonGroup();
        this.bothS = new JScrollPane();
        this.bothT = new JTextPane();
        this.errorS = new JScrollPane();
        this.errorT = new JTextPane();
        this.outS = new JScrollPane();
        this.outT = new JTextPane();
        this.jToolBar1 = new JToolBar();
        this.clean = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.output = new JToggleButton();
        this.error = new JToggleButton();
        this.both = new JToggleButton();
        this.commandP = new JPanel();
        this.jLabel1 = new JLabel();
        this.input = new JAutoCompleteTextField();
        this.viewport = new JPanel();
        this.bothT.setEditable(false);
        this.bothT.setFont(new Font("Monospaced", 0, 13));
        this.bothS.setViewportView(this.bothT);
        this.errorT.setEditable(false);
        this.errorT.setFont(new Font("Monospaced", 0, 13));
        this.errorS.setViewportView(this.errorT);
        this.outT.setEditable(false);
        this.outT.setFont(new Font("Monospaced", 0, 13));
        this.outS.setViewportView(this.outT);
        this.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.clean.setIcon(new ImageIcon(this.getClass().getResource("/icons/sweep.png")));
        this.clean.setFocusable(false);
        this.clean.setHorizontalTextPosition(0);
        this.clean.setVerticalTextPosition(3);
        this.clean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IOPlugin.this.cleanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.clean);
        this.jToolBar1.add(this.filler1);
        this.outputErrorGroup.add(this.output);
        this.output.setText("O");
        this.output.setFocusable(false);
        this.output.setHorizontalAlignment(4);
        this.output.setHorizontalTextPosition(0);
        this.output.setVerticalTextPosition(3);
        this.output.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IOPlugin.this.jumptToViewport(evt);
            }
        });
        this.jToolBar1.add(this.output);
        this.outputErrorGroup.add(this.error);
        this.error.setText("E");
        this.error.setFocusable(false);
        this.error.setHorizontalAlignment(4);
        this.error.setHorizontalTextPosition(0);
        this.error.setVerticalTextPosition(3);
        this.error.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IOPlugin.this.jumptToViewport(evt);
            }
        });
        this.jToolBar1.add(this.error);
        this.outputErrorGroup.add(this.both);
        this.both.setSelected(true);
        this.both.setText("O/E");
        this.both.setFocusable(false);
        this.both.setHorizontalAlignment(4);
        this.both.setHorizontalTextPosition(0);
        this.both.setVerticalTextPosition(3);
        this.both.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IOPlugin.this.jumptToViewport(evt);
            }
        });
        this.jToolBar1.add(this.both);
        this.add((Component)this.jToolBar1, "First");
        this.commandP.setLayout(new BoxLayout(this.commandP, 0));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/icons/gearsmall.png")));
        this.commandP.add(this.jLabel1);
        this.input.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IOPlugin.this.inputActionPerformed(evt);
            }
        });
        this.commandP.add(this.input);
        this.add((Component)this.commandP, "South");
        this.viewport.setLayout(new BorderLayout());
        this.add((Component)this.viewport, "Center");
    }

    private void inputActionPerformed(ActionEvent evt) {
        this.eval(this.input.getText(), false);
    }

    private void jumptToViewport(ActionEvent evt) {
        this.viewportUpdate();
    }

    private void cleanActionPerformed(ActionEvent evt) {
        this.outT.setText("");
        this.errorT.setText("");
        this.bothT.setText("");
    }
}

