/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.plugin.io;

import com.panayotis.xray.plugin.io.CustomAction;
import com.panayotis.xray.plugin.io.History;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;

public class JAutoCompleteTextField
extends JTextField
implements CustomAction {
    private final History history = new History();

    public JAutoCompleteTextField() {
        this.init();
    }

    public JAutoCompleteTextField(String text) {
        super(text);
        this.init();
    }

    public JAutoCompleteTextField(int columns) {
        super(columns);
        this.init();
    }

    public JAutoCompleteTextField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public JAutoCompleteTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.init();
    }

    private void init() {
        this.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if ((long)e.getModifiers() != 128L) {
                    switch (e.getKeyCode()) {
                        case 38: {
                            String prev = JAutoCompleteTextField.this.history.previous();
                            if (prev == null) break;
                            JAutoCompleteTextField.this.setText(prev);
                            break;
                        }
                        case 40: {
                            String prev = JAutoCompleteTextField.this.history.next();
                            if (prev == null) break;
                            JAutoCompleteTextField.this.setText(prev);
                            break;
                        }
                        case 9: {
                            System.out.println("Auto Complete");
                            break;
                        }
                        case 10: {
                            if (JAutoCompleteTextField.this.getText().isEmpty()) break;
                            JAutoCompleteTextField.this.history.send();
                            JAutoCompleteTextField.this.setText("");
                            break;
                        }
                        default: {
                            JAutoCompleteTextField.this.history.update(JAutoCompleteTextField.this.getText());
                        }
                    }
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "*none*");
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "*none*");
    }
}

