/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.props;

import com.panayotis.xray.props.BeanPropertyRecognizer;
import com.panayotis.xray.props.ConstrainedPanel;
import com.panayotis.xray.props.PropertyGenerator;
import com.panayotis.xray.props.PropertyManager;
import com.panayotis.xray.props.PropertyRecognizer;
import com.panayotis.xray.props.PropertyResolver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PropertyManagerFactory {
    private final PropertyResolver resolv;
    private final PropertyRecognizer recogn;

    public PropertyManagerFactory() {
        this(null, null);
    }

    public PropertyManagerFactory(PropertyRecognizer recogn) {
        this(null, recogn);
    }

    public PropertyManagerFactory(PropertyResolver resolv) {
        this(resolv, null);
    }

    public PropertyManagerFactory(PropertyResolver resolv, PropertyRecognizer recogn) {
        if (resolv == null) {
            resolv = new PropertyResolver();
        }
        if (recogn == null) {
            recogn = new BeanPropertyRecognizer();
        }
        this.resolv = resolv;
        this.recogn = recogn;
    }

    public <T> void register(Class<T> type, PropertyGenerator<T> generator) {
        this.resolv.register(type, generator);
    }

    public JComponent getView(Object instance) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        ConstrainedPanel titlePanel = new ConstrainedPanel(new BorderLayout());
        JLabel title = new JLabel(instance.getClass().getName());
        JLabel hash = new JLabel("@" + Integer.toHexString(instance.hashCode()));
        hash.setHorizontalAlignment(2);
        title.setFont(title.getFont().deriveFont(1));
        titlePanel.add((Component)title, "West");
        titlePanel.add((Component)hash, "Center");
        panel.add(titlePanel);
        for (PropertyManager p : this.retrieveList(instance)) {
            ConstrainedPanel constraint = new ConstrainedPanel(new BorderLayout());
            constraint.add((Component)p.getView(), "Center");
            panel.add(constraint);
        }
        return panel;
    }

    private List<PropertyManager> retrieveList(Object instance) {
        ArrayList<PropertyManager> props = new ArrayList<PropertyManager>();
        TreeMap properties = new TreeMap();
        Class<?> cls = instance.getClass();
        for (Method m : cls.getMethods()) {
            if (this.recogn.isSetter(m)) {
                PropertyManagerFactory.getValue(properties, this.recogn.getNameFromSetter(m), () -> new PropMethods()).setter = m;
                continue;
            }
            if (!this.recogn.isGetter(m)) continue;
            PropertyManagerFactory.getValue(properties, this.recogn.getNameFromGetter(m), () -> new PropMethods()).getter = m;
        }
        for (PropMethods methods : properties.values()) {
            if (methods.getter == null) continue;
            props.add(this.resolv.resolve(instance, this.recogn.getNameFromGetter(methods.getter), methods.setter, methods.getter));
        }
        return props;
    }

    static <K, V> V getValue(Map<K, V> map, K key, Supplier<V> keyConstructor) {
        V val = map.get(key);
        if (val == null) {
            val = keyConstructor.get();
            map.put(key, val);
        }
        return val;
    }

    static class PropMethods {
        private Method getter;
        private Method setter;

        PropMethods() {
        }
    }
}

