/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.props;

import java.lang.reflect.Method;

public interface PropertyRecognizer {
    public boolean isGetter(Method var1);

    public boolean isSetter(Method var1);

    public String getNameFromGetter(Method var1);

    public String getNameFromSetter(Method var1);

    public static String getNameFromType(Class cls, String regexToRemove, boolean firstRemovePackage) {
        String name = cls.getName();
        if (firstRemovePackage) {
            name = PropertyRecognizer.removePackageName(name);
        }
        if (regexToRemove != null && !regexToRemove.isEmpty()) {
            name = name.replaceAll(regexToRemove, "");
        }
        if (!firstRemovePackage) {
            name = PropertyRecognizer.removePackageName(name);
        }
        return PropertyRecognizer.getDefaultCapitalizedName(name);
    }

    public static String removePackageName(String name) {
        int point = name.lastIndexOf(46);
        return point >= 0 ? name.substring(point + 1) : name;
    }

    public static String getDefaultCapitalizedName(String name) {
        if (name == null) {
            return null;
        }
        name = name.length() > 1 ? name.substring(0, 1).toUpperCase() + name.substring(1) : name.toUpperCase();
        String[] parts = name.split("(?<=[a-z])(?=[A-Z])|(?<=[A-Z])(?=[A-Z][a-z])");
        StringBuilder out = new StringBuilder();
        for (String part : parts) {
            out.append(' ').append(part);
        }
        return out.length() <= 1 ? out.toString() : out.substring(1);
    }
}

