/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.props.commons;

import com.panayotis.xray.props.commons.AwareDefaults;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

public class AwareSpinner
extends JPanel {
    private final JSpinner spinner;
    private final SpinnerNumberModel model;

    public AwareSpinner(int min, int max) {
        super(new BorderLayout());
        this.model = new SpinnerNumberModel(0, min, max, 1);
        this.spinner = new JSpinner(this.model);
        this.spinner.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AwareSpinner.this.setOpaque(e.getKeyCode() != 10);
            }
        });
        this.add((Component)this.spinner, "Center");
        this.setOpaque(false);
        this.setBackground(AwareDefaults.DIRTY);
    }

    public int getValue() {
        return this.model.getNumber().intValue();
    }

    public void setValue(Number n) {
        this.model.setValue(n);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.spinner.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void addChangeListener(ChangeListener listener) {
        this.spinner.addChangeListener(listener);
    }
}

