/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.props.commons;

import com.panayotis.xray.props.PropertyManager;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.lang.reflect.Method;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EnumPropertyManager
extends PropertyManager<Object> {
    private JComboBox cb;
    private Object[] constants;

    public EnumPropertyManager(Object instance, String name, Method setter, Method getter) {
        super(instance, name, setter, getter);
        this.constants = getter.getReturnType().getEnumConstants();
    }

    @Override
    protected JComponent createView() {
        if (this.cb == null) {
            this.cb = new JComboBox<Object>(this.constants);
            this.cb.addItemListener(a -> this.updateValue(a));
        }
        this.cb.setEnabled(!this.isReadOnly());
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(1, 2));
        p.add(new JLabel(this.getName()));
        p.add(this.cb);
        return p;
    }

    @Override
    public void updateView(Object value) {
        this.cb.setSelectedItem(value);
    }

    private void updateValue(ItemEvent a) {
        if (a.getStateChange() != 1) {
            return;
        }
        this.setValue(this.cb.getSelectedItem());
    }

    @Override
    public Object defaultValue() {
        return null;
    }
}

