/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.sys;

import com.panayotis.xray.sys.MainResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CommandArgs {
    private String classpath;
    private String[] classpathArr;
    private String jar;
    private final List<String> givenArgs = new ArrayList<String>();
    private String mainClass = "";

    public CommandArgs(String[] args) {
        if (args == null || args.length < 0) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-help")) {
                this.showHelp();
                continue;
            }
            if (this.mainClass.isEmpty() && arg.equals("-classpath") | arg.equals("-cp")) {
                if (i + 1 >= args.length) {
                    this.parseError("Class path requires an argument");
                }
                if (this.classpath != null) {
                    this.parseError("Class path already defined");
                }
                this.classpath = args[++i];
                continue;
            }
            if (this.mainClass.isEmpty() && arg.equals("-jar")) {
                if (i + 1 >= args.length) {
                    this.parseError("JAR file requires an argument");
                }
                if (this.jar != null) {
                    this.parseError("JAR file already defined");
                }
                this.jar = args[++i];
                MainResolver.getMainFromJar(this.jar, this);
                if (!this.mainClass.isEmpty()) continue;
                this.parseError("Unable to retrieve main class from JAR file " + this.jar);
                continue;
            }
            if (!this.mainClass.isEmpty()) {
                this.givenArgs.add(arg);
                continue;
            }
            if (this.classpath == null && this.jar == null) {
                this.parseError("Please provide either class path or jar file before defining other arguments");
            }
            this.mainClass = arg;
        }
        if (this.classpath != null && this.mainClass.isEmpty()) {
            this.parseError("Missing definition of main class, when defining class path");
        }
    }

    void setMain(String main) {
        this.mainClass = main == null ? "" : main;
    }

    void appendClasspath(String classpath) {
        this.classpath = this.classpath == null || this.classpath.isEmpty() ? classpath : this.classpath + ":" + classpath;
    }

    private void parseError(String error) {
        System.err.println();
        System.err.println(error);
        System.err.println();
        this.showHelp();
    }

    private void showHelp() {
        System.err.println("Usage: java JAVA_OPTIONS -jar xray.jar -cp|-classpath CLASSPATH Main.Class ARGS...\n       java JAVA_OPTIONS -jar xray.jar [-cp|-classpath CLASSPATH] -jar APP.jar ARGS...\n       java -help\nWhere\n  JAVA_OPTIONS : the required by the application Java options\n  CLASSPATH    : the classpath of the application to examine\n  Main.Class   : the main class of the application to execute\n  APP.jar      : the application JAR\n  ARGS...      : The possible application arguments\n");
        System.exit(-1);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String[] getClasspath() {
        if (this.classpathArr == null) {
            if (this.jar == null) {
                this.classpathArr = this.classpath.split(File.pathSeparator);
            } else {
                File base = new File(this.jar).getParentFile().getAbsoluteFile();
                ArrayList<String> cpArray = new ArrayList<String>();
                if (this.classpath != null && !this.classpath.isEmpty()) {
                    for (String pathname : this.classpath.split(File.pathSeparator)) {
                        cpArray.add(new File(base, pathname).getAbsolutePath());
                    }
                }
                cpArray.add(this.jar);
                this.classpathArr = cpArray.toArray(new String[cpArray.size()]);
            }
        }
        return this.classpathArr;
    }

    public String getJar() {
        return this.jar;
    }

    public String[] getArguments() {
        return this.givenArgs.toArray(new String[this.givenArgs.size()]);
    }
}

