/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.sys;

import com.panayotis.xray.sys.CommandArgs;
import com.panayotis.xray.sys.EIterable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class MainResolver {
    public static Method retrieveMain(String[] cp) {
        HashSet<Method> possible = new HashSet<Method>();
        for (String pathname : cp) {
            File path = new File(pathname);
            if (path.isFile()) {
                try {
                    JarFile jar = new JarFile(path);
                    for (JarEntry entry : new EIterable<JarEntry>(jar.entries())) {
                        String name = entry.getName();
                        if (!name.toLowerCase().endsWith(".class")) continue;
                        MainResolver.checkClass(name.substring(0, name.length() - 6).replace('/', '.'), possible);
                    }
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            if (!path.isDirectory()) continue;
            MainResolver.iterateFiles(path, "", possible);
        }
        System.out.println(possible);
        switch (possible.size()) {
            case 1: {
                return (Method)possible.iterator().next();
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    private static void iterateFiles(File root, String packg, Collection<Method> possible) {
        File[] files = root.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File f : files) {
            String name = f.getName();
            if (f.isDirectory()) {
                MainResolver.iterateFiles(f, packg.isEmpty() ? name : packg + "." + name, possible);
                continue;
            }
            if (!f.isFile() || !name.toLowerCase().endsWith(".class")) continue;
            MainResolver.checkClass(packg + (packg.isEmpty() ? "" : ".") + name.substring(0, name.length() - 6).replace('/', '.').replace('\\', '.'), possible);
        }
    }

    private static void checkClass(String name, Collection<Method> mainFound) {
        try {
            Method m = Class.forName(name).getMethod("main", String[].class);
            int modifiers = m.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && m.getReturnType().equals(Void.TYPE)) {
                mainFound.add(m);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void getMainFromJar(String filename, CommandArgs args) {
        Attributes attrs = null;
        try {
            attrs = new JarFile(filename).getManifest().getMainAttributes();
        }
        catch (IOException ex) {
            System.err.println("Unable to locate file " + filename);
            return;
        }
        for (Attributes.Name name : attrs.keySet()) {
            String name2 = name.toString().toLowerCase().trim();
            if (name2.equals("main-class")) {
                args.setMain(attrs.getValue(name));
                continue;
            }
            if (!name2.equals("class-path")) continue;
            args.appendClasspath(attrs.getValue(name).trim().replaceAll("( )+", " ").replace(' ', File.pathSeparatorChar));
        }
    }
}

