/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.sys;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.function.Consumer;

public class RedirectPrintStream
extends PrintStream {
    private final Consumer<String> cons;

    public RedirectPrintStream(OutputStream out, Consumer<String> cons) {
        super(out);
        this.cons = cons;
    }

    @Override
    public void print(Object obj) {
        this.cons.accept(obj == null ? "null" : obj.toString());
    }

    @Override
    public void print(String s) {
        this.cons.accept(s == null ? "null" : s);
    }

    @Override
    public void print(boolean b) {
        this.cons.accept(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.cons.accept(String.valueOf(c));
    }

    @Override
    public void print(char[] s) {
        this.cons.accept(new String(s));
    }

    @Override
    public void print(double d) {
        this.cons.accept(Double.toString(d));
    }

    @Override
    public void print(float f) {
        this.cons.accept(Float.toString(f));
    }

    @Override
    public void print(int i) {
        this.cons.accept(Integer.toString(i));
    }

    @Override
    public void print(long l) {
        this.cons.accept(Long.toString(l));
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        this.cons.accept(String.format(format, args));
        return this;
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        this.cons.accept(String.format(l, format, args));
        return this;
    }

    @Override
    public void println() {
        this.cons.accept("\n");
    }

    @Override
    public void println(Object x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.println();
    }
}

