/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.tree;

import com.panayotis.xray.props.PropertyRecognizer;
import com.panayotis.xray.tree.PropertyTreeNode;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public interface PropertyTreeDecorator<T> {
    default public String getName(T item) {
        return PropertyRecognizer.getNameFromType(item.getClass(), null, true);
    }

    default public Icon getIcon(T item) {
        return null;
    }

    default public TreeCellRenderer getRenderer() {
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component result = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                Object item = ((PropertyTreeNode)value).getItem();
                Icon icon = item != null ? PropertyTreeDecorator.this.getIcon(item) : null;
                this.setIconTextGap(1);
                this.setIcon(icon == null ? this.leafIcon : icon);
                this.setText(PropertyTreeDecorator.this.getName(item));
                return result;
            }
        };
    }
}

