/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.xray.tree;

import com.panayotis.xray.plugin.XRayPlugin;
import com.panayotis.xray.props.PropertyManagerFactory;
import com.panayotis.xray.tree.PropertyTreeModel;
import com.panayotis.xray.tree.PropertyTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public abstract class PropertyTreePlugin<T>
extends JPanel
implements XRayPlugin {
    private final PropertyManagerFactory factory;
    private final PropertyTreeModel<T> model;
    private final String name;
    private final int order;
    private T selected = null;
    private JScrollPane props = null;
    private JSplitPane both = null;
    private TimerTask task = new TimerTask(){

        @Override
        public void run() {
            PropertyTreePlugin.this.refresh(true);
        }
    };
    private JToggleButton bothB;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JComboBox<String> jComboBox1;
    private JPanel jPanel1;
    private JToggleButton onceB;
    private JToggleButton propB;
    private JToggleButton timedB;
    private JToolBar toolbar;
    private JTree tree;
    private JToggleButton treeB;
    private JScrollPane treeView;
    private JPanel viewport;
    private ButtonGroup viewtypeBG;

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name) {
        this(model, name, 500);
    }

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name, PropertyManagerFactory factory) {
        this(model, name, 500, factory);
    }

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name, int order) {
        this(model, name, order, new PropertyManagerFactory());
    }

    public PropertyTreePlugin(PropertyTreeModel<T> model, String name, int order, PropertyManagerFactory factory) {
        this.initComponents();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setModel(null);
        this.tree.setUI(new BasicTreeUI(){

            @Override
            public int getRightChildIndent() {
                return 5;
            }

            @Override
            protected int getRowX(int row, int depth) {
                return super.getRowX(row, depth) * 6 / 11;
            }
        });
        this.factory = factory;
        this.name = name;
        this.order = order;
        this.model = model;
        TreeCellRenderer renderer = model.getTreeDecorator().getRenderer();
        if (renderer != null) {
            this.tree.setCellRenderer(renderer);
        }
    }

    @Override
    public String getPluginName() {
        return this.name;
    }

    @Override
    public JComponent getPluginVisuals() {
        return this;
    }

    @Override
    public int getPluginOrder() {
        return this.order;
    }

    @Override
    public void onFocus() {
        this.refresh(true);
    }

    public void addToolbarButton(AbstractButton button) {
        this.toolbar.add((Component)button, this.toolbar.getComponentCount() - 4);
    }

    public T getSelectedItem() {
        return this.selected;
    }

    public synchronized void refresh(boolean shouldRefreshTree) {
        SwingUtilities.invokeLater(() -> {
            this.viewport.removeAll();
            if (this.treeView != null && this.treeView.getParent() != null) {
                this.treeView.getParent().remove(this.treeView);
            }
            if (this.props != null && this.props.getParent() != null) {
                this.props.getParent().remove(this.props);
            }
            if (this.both != null) {
                if (this.both.getParent() != null) {
                    this.both.getParent().remove(this.both);
                }
                this.both.removeAll();
            }
            JComponent cmp = this.treeB.isSelected() ? this.updateTree() : (this.propB.isSelected() ? this.updateProps() : this.updateBoth(shouldRefreshTree));
            this.viewport.add((Component)cmp, "Center");
            this.viewport.revalidate();
            this.viewport.repaint();
        });
    }

    private JComponent updateTree() {
        this.tree.setModel(new DefaultTreeModel(new PropertyTreeNode<T>(this.model)));
        TreePath path = null;
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            this.tree.expandRow(row);
            if (path != null || ((PropertyTreeNode)(path = this.tree.getPathForRow(row)).getLastPathComponent()).getItem() == this.selected) continue;
            path = null;
        }
        if (path != null) {
            this.tree.getSelectionModel().setSelectionPath(path);
        }
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        return this.treeView;
    }

    private JComponent updateProps() {
        if (this.selected == null) {
            return new JLabel("Please select an item first", 0);
        }
        Rectangle pos = this.props == null ? null : this.props.getViewport().getViewRect();
        this.props = new JScrollPane(this.factory.getView(this.selected));
        this.props.getVerticalScrollBar().setUnitIncrement(20);
        if (pos != null) {
            this.props.getViewport().scrollRectToVisible(pos);
        }
        return this.props;
    }

    private JComponent updateBoth(boolean shouldRefreshTree) {
        JComponent c1 = shouldRefreshTree ? this.updateTree() : this.treeView;
        JComponent c2 = this.updateProps();
        c1.setMinimumSize(new Dimension(20, 50));
        c2.setMinimumSize(new Dimension(100, 50));
        int divider = -1;
        if (this.both != null) {
            divider = this.both.getDividerLocation();
        }
        this.both = new JSplitPane(1, c1, c2);
        this.both.setDividerSize(7);
        this.both.setResizeWeight(this.getTreeResizeWeight());
        if (divider < 0) {
            this.both.setDividerLocation(140);
        } else {
            this.both.setDividerLocation(divider);
        }
        return this.both;
    }

    protected double getTreeResizeWeight() {
        return 0.6;
    }

    public PropertyManagerFactory getFactory() {
        return this.factory;
    }

    private void initComponents() {
        this.viewtypeBG = new ButtonGroup();
        this.treeView = new JScrollPane();
        this.tree = new JTree();
        this.toolbar = new JToolBar();
        this.onceB = new JToggleButton();
        this.timedB = new JToggleButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.filler1 = new Box.Filler(new Dimension(8, 0), new Dimension(8, 0), new Dimension(8, Short.MAX_VALUE));
        this.treeB = new JToggleButton();
        this.propB = new JToggleButton();
        this.bothB = new JToggleButton();
        this.viewport = new JPanel();
        this.jPanel1 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.treeView.setMinimumSize(new Dimension(100, 100));
        this.tree.setMinimumSize(new Dimension(30, 30));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PropertyTreePlugin.this.treeValueChanged(evt);
            }
        });
        this.treeView.setViewportView(this.tree);
        this.setLayout(new BorderLayout());
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.onceB.setIcon(new ImageIcon(this.getClass().getResource("/icons/reload1.png")));
        this.onceB.setFocusable(false);
        this.onceB.setHorizontalTextPosition(0);
        this.onceB.setVerticalTextPosition(3);
        this.onceB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyTreePlugin.this.onceBActionPerformed(evt);
            }
        });
        this.toolbar.add(this.onceB);
        this.timedB.setIcon(new ImageIcon(this.getClass().getResource("/icons/reload.png")));
        this.timedB.setFocusable(false);
        this.timedB.setHorizontalTextPosition(0);
        this.timedB.setVerticalTextPosition(3);
        this.timedB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyTreePlugin.this.timedBActionPerformed(evt);
            }
        });
        this.toolbar.add(this.timedB);
        this.toolbar.add(this.filler2);
        this.toolbar.add(this.filler1);
        this.viewtypeBG.add(this.treeB);
        this.treeB.setIcon(new ImageIcon(this.getClass().getResource("/icons/views.png")));
        this.treeB.setSelected(true);
        this.treeB.setFocusable(false);
        this.treeB.setHorizontalTextPosition(0);
        this.treeB.setVerticalTextPosition(3);
        this.treeB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PropertyTreePlugin.this.viewStateChanged(evt);
            }
        });
        this.toolbar.add(this.treeB);
        this.viewtypeBG.add(this.propB);
        this.propB.setIcon(new ImageIcon(this.getClass().getResource("/icons/props.png")));
        this.propB.setFocusable(false);
        this.propB.setHorizontalTextPosition(0);
        this.propB.setVerticalTextPosition(3);
        this.propB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PropertyTreePlugin.this.viewStateChanged(evt);
            }
        });
        this.toolbar.add(this.propB);
        this.viewtypeBG.add(this.bothB);
        this.bothB.setIcon(new ImageIcon(this.getClass().getResource("/icons/both.png")));
        this.bothB.setFocusable(false);
        this.bothB.setHorizontalTextPosition(0);
        this.bothB.setVerticalTextPosition(3);
        this.bothB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PropertyTreePlugin.this.viewStateChanged(evt);
            }
        });
        this.toolbar.add(this.bothB);
        this.add((Component)this.toolbar, "North");
        this.viewport.setLayout(new BorderLayout());
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanel1.add(this.jComboBox1);
        this.viewport.add((Component)this.jPanel1, "Center");
        this.add((Component)this.viewport, "Center");
    }

    private void onceBActionPerformed(ActionEvent evt) {
        this.onceB.setEnabled(false);
        this.timedB.setEnabled(false);
        SwingUtilities.invokeLater(() -> {
            this.refresh(true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    PropertyTreePlugin.this.onceB.setEnabled(true);
                    PropertyTreePlugin.this.timedB.setEnabled(true);
                    PropertyTreePlugin.this.onceB.setSelected(false);
                }
            }, 100L);
        });
    }

    private void treeValueChanged(TreeSelectionEvent evt) {
        this.selected = ((PropertyTreeNode)evt.getPath().getLastPathComponent()).getItem();
        if (this.bothB.isSelected()) {
            this.refresh(false);
        }
    }

    private void viewStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.refresh(evt.getSource() == this.bothB);
        }
    }

    private void timedBActionPerformed(ActionEvent evt) {
        if (this.timedB.isSelected()) {
            this.onceB.setEnabled(false);
            if (this.task != null) {
                new Timer().scheduleAtFixedRate(this.task, 0L, 1000L);
            }
        } else if (this.task != null) {
            this.task.cancel();
            this.onceB.setEnabled(true);
            this.task = null;
        }
    }
}

