/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.panayotis.xray;

import com.panayotis.xray.plugin.PluginManager;
import com.panayotis.xray.plugin.XRayPlugin;
import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JToggleButton;

/**
 *
 * @author teras
 */
public class XRayWindow extends javax.swing.JFrame {

    /**
     * Creates new form XRayForm
     */
    @SuppressWarnings("OverridableMethodCallInConstructor")
    public XRayWindow() {
        super("XRay Application");
        initComponents();
        init();
    }

    // Invoke later due to lazy initialization of plugins
    private void init() {
        JToggleButton first = null;
        for (XRayPlugin plugin : PluginManager.plugins()) {
            String name = plugin.getPluginName();
            JToggleButton button = new JToggleButton(plugin.getPluginName());
            JComponent visual = plugin.getPluginVisuals();
            toolbar.add(button);
            buttongroup.add(button);
            viewarea.add(visual, name);
            button.addActionListener((ActionEvent e) -> {
                ((CardLayout) viewarea.getLayout()).show(viewarea, name);
                plugin.onFocus();
            });
            if (first == null)
                first = button;
        }
        if (first != null)
            first.setSelected(true);
    }

    /**
     * This method is called from within the constructor to postInit the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttongroup = new javax.swing.ButtonGroup();
        panel = new javax.swing.JPanel();
        viewarea = new javax.swing.JPanel();
        toolbar = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setMinimumSize(new java.awt.Dimension(300, 300));
        getContentPane().setLayout(new java.awt.BorderLayout(5, 0));

        panel.setLayout(new java.awt.BorderLayout());

        viewarea.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 8, 8, 8));
        viewarea.setLayout(new java.awt.CardLayout());
        panel.add(viewarea, java.awt.BorderLayout.CENTER);

        toolbar.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));
        panel.add(toolbar, java.awt.BorderLayout.NORTH);

        getContentPane().add(panel, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttongroup;
    private javax.swing.JPanel panel;
    private javax.swing.JPanel toolbar;
    private javax.swing.JPanel viewarea;
    // End of variables declaration//GEN-END:variables

}
